import { defineComponent, computed, resolveComponent, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderStyle, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ProductColors",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const uniqueColors = computed(() => {
      if (!props.product || !props.product.product_colors) return [];
      const seen = /* @__PURE__ */ new Set();
      return props.product.product_colors.filter((item) => {
        if (!item.color) return false;
        const key = item.color.name || item.color.code;
        if (seen.has(key)) return false;
        seen.add(key);
        return true;
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      if (uniqueColors.value.length) {
        _push(`<div${ssrRenderAttrs(_attrs)}><ul class="mt-10"><!--[-->`);
        ssrRenderList(uniqueColors.value, (item, index) => {
          _push(`<li>`);
          if (item.color !== null) {
            _push(`<div class="color" style="${ssrRenderStyle({ backgroundColor: item.color.code })}"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        });
        _push(`<!--]--></ul></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/search/ProductColors.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Score",
  __ssrInlineRender: true,
  props: {
    product: {},
    showCount: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.product.score && _ctx.product.score_from_sale_count > 0) {
        _push(`<div${ssrRenderAttrs(_attrs)}>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "fa-star"],
          style: { "color": "#f9bc00" }
        }, null, _parent));
        _push(`<span>${ssrInterpolate(_ctx.product.score)}</span>`);
        if (_ctx.showCount) {
          _push(`<span> (${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.product.score_from_sale_count))}) </span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/Score.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main$1 as _, _sfc_main as a };
//# sourceMappingURL=Score-BYZAscMc.mjs.map
