import { _ as _sfc_main$1 } from './TextInput-BtVMT3NE.mjs';
import { h as _sfc_main$k, c as useNuxtApp, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, ref, unref, isRef, withCtx, createVNode, createBlock, openBlock, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass, ssrInterpolate } from 'vue/server-renderer';
import { u as useOrderStore } from './index-Co4X6G3O.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "RegisterCode",
  __ssrInlineRender: true,
  setup(__props) {
    const code = ref(null);
    const successMessage = ref(null);
    const errorMessage = ref(null);
    const loading = ref(false);
    const order = useOrderStore();
    const sendRequest = () => {
      if (code.value && code.value.length >= 3) {
        loading.value = true;
        useNuxtApp().$axios.post(
          useRuntimeConfig().public.staticApi + "/response.php?file=status-ok",
          {
            "code": code.value
          }
        ).then((response) => {
          loading.value = false;
          if (response.data.status == "ok") {
            code.value = null;
            successMessage.value = "\u06A9\u062F \u062A\u062E\u0641\u06CC\u0641 \u0648\u0627\u0631\u062F \u0634\u062F\u0647 \u0635\u062D\u06CC\u062D \u0645\u06CC \u0628\u0627\u0634\u062F";
            order.updateItemsDeducted({
              ...order.itemsDeducted,
              ...{ discount: { title: "\u062A\u062E\u0641\u06CC\u0641", value: 1e5 } }
            });
          }
          setTimeout(() => {
            successMessage.value = null;
            errorMessage.value = null;
          }, 4e3);
        }).catch(() => {
          loading.value = false;
        });
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$1;
      const _component_Loading = _sfc_main$k;
      _push(`<div${ssrRenderAttrs(_attrs)}><div><span class="font-bold">\u06A9\u062F \u062A\u062E\u0641\u06CC\u0641</span></div><div><p class="text-gray-400 py-3"> \u062F\u0631 \u0635\u0648\u0631\u062A \u062F\u0627\u0634\u062A\u0646 \u06A9\u062F \u062A\u062E\u0641\u06CC\u0641 \u0645\u06CC\u062A\u0648\u0627\u0646\u06CC\u062F \u0648\u0627\u0631\u062F \u0646\u0645\u0627\u06CC\u06CC\u062F </p>`);
      _push(ssrRenderComponent(_component_FormTextInput, {
        class: "w-full md:w-1/2",
        placeholder: "\u0648\u0627\u0631\u062F \u06A9\u0631\u062F\u0646 \u06A9\u062F \u062A\u062E\u0641\u06CC\u0641",
        modelValue: unref(code),
        "onUpdate:modelValue": ($event) => isRef(code) ? code.value = $event : null
      }, {
        suffix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="px-3 flex items-center cursor-pointer"${_scopeId}>`);
            if (!unref(loading)) {
              _push2(`<span class="${ssrRenderClass([unref(code) ? "text-black" : "text-gray-400"])}"${_scopeId}> \u062B\u0628\u062A </span>`);
            } else {
              _push2(ssrRenderComponent(_component_Loading, null, null, _parent2, _scopeId));
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: "px-3 flex items-center cursor-pointer",
                onClick: sendRequest
              }, [
                !unref(loading) ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: [unref(code) ? "text-black" : "text-gray-400"]
                }, " \u062B\u0628\u062A ", 2)) : (openBlock(), createBlock(_component_Loading, { key: 1 }))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(successMessage)) {
        _push(`<div class="alert alert-success">${ssrInterpolate(unref(successMessage))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/discount/RegisterCode.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=RegisterCode-CB980fsG.mjs.map
