import { mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main = {
  __name: "Radio",
  __ssrInlineRender: true,
  props: {
    selected: {
      type: Boolean
    },
    title: {
      type: String
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center" }, _attrs))}><label class="radio-button-label flex lh-25 cursor-pointer text-sm mx-1.5 items-center"><span class="${ssrRenderClass([{ "active": __props.selected === true }, "checkmark"])}"></span></label>`);
      if (__props.title) {
        _push(`<span>${ssrInterpolate(__props.title)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/Radio.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=Radio-RGh-QAWY.mjs.map
