import { u as useState, b as useRuntimeConfig, g as __nuxt_component_0$2, c as useNuxtApp, o as _sfc_main$c } from './server.mjs';
import { defineComponent, mergeProps, withCtx, unref, createBlock, createCommentVNode, createVNode, openBlock, toDisplayString, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderClass, ssrInterpolate, ssrRenderAttrs, ssrRenderList, ssrRenderVNode } from 'vue/server-renderer';
import { _ as _sfc_main$3 } from './NuxtImg-DBEieluz.mjs';
import { _ as _sfc_main$1$1, a as _sfc_main$4 } from './Score-BYZAscMc.mjs';

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "BeforeProductView",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const global = useNuxtApp().vueApp.config.globalProperties;
    let beforeContent = global["$product-search-view:before-view"];
    if (beforeContent) {
      beforeContent = global.$sort(beforeContent, "index");
    }
    return (_ctx, _push, _parent, _attrs) => {
      if (unref(beforeContent)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex justify-between items-center" }, _attrs))}><!--[-->`);
        ssrRenderList(unref(beforeContent), (row) => {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(row.component), { product: _ctx.product }, null), _parent);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/search/BeforeProductView.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ProductPrice",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PriceVariationPriceBox = _sfc_main$c;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "price flex justify-end pt-2" }, _attrs))}>`);
      if (_ctx.product.status == 1 && _ctx.product.variation !== null) {
        _push(`<div>`);
        _push(ssrRenderComponent(_component_PriceVariationPriceBox, {
          variation: _ctx.product.variation
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div><span class="font-bold lg:text-xl text-gray-600"> \u0646\u0627\u0645\u0648\u062C\u0648\u062F </span></div>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/search/ProductPrice.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ProductView",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const theme = useState("theme");
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_ThemeSearchBeforeProductView = _sfc_main$2;
      const _component_NuxtImg = _sfc_main$3;
      const _component_ThemeSearchProductColors = _sfc_main$1$1;
      const _component_CommentScore = _sfc_main$4;
      const _component_ThemeSearchProductPrice = _sfc_main$1;
      _push(ssrRenderComponent(_component_nuxt_link, mergeProps({
        to: _ctx.$getProductPath(_ctx.product),
        class: "product"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(theme) != "desktop") {
              _push2(ssrRenderComponent(_component_ThemeSearchBeforeProductView, { product: _ctx.product }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="${ssrRenderClass([{ "flex-col": unref(theme) != "mobile" }, "flex"])}"${_scopeId}><div${_scopeId}>`);
            if (unref(theme) == "desktop") {
              _push2(ssrRenderComponent(_component_ThemeSearchBeforeProductView, { product: _ctx.product }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(_component_NuxtImg, {
              src: unref(serverUrl) + "/thumbnails/" + _ctx.product.image,
              class: "product-image",
              format: "webp",
              width: 200,
              height: 200,
              loading: "lazy",
              alt: ""
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_ThemeSearchProductColors, {
              class: "product-colors",
              product: _ctx.product
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="flex flex-col justify-between w-full flex-grow"${_scopeId}><div class="title title-twl font-bold"${_scopeId}>${ssrInterpolate(_ctx.product.title)}</div><div${_scopeId}><div class="w-full flex justify-end pt-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_CommentScore, { product: _ctx.product }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(theme) == "mobile") {
              _push2(ssrRenderComponent(_component_ThemeSearchProductPrice, {
                product: _ctx.product,
                class: "pt-3"
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div></div>`);
            if (unref(theme) != "mobile") {
              _push2(ssrRenderComponent(_component_ThemeSearchProductPrice, { product: _ctx.product }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(theme) != "desktop" ? (openBlock(), createBlock(_component_ThemeSearchBeforeProductView, {
                key: 0,
                product: _ctx.product
              }, null, 8, ["product"])) : createCommentVNode("", true),
              createVNode("div", {
                class: ["flex", { "flex-col": unref(theme) != "mobile" }]
              }, [
                createVNode("div", null, [
                  unref(theme) == "desktop" ? (openBlock(), createBlock(_component_ThemeSearchBeforeProductView, {
                    key: 0,
                    product: _ctx.product
                  }, null, 8, ["product"])) : createCommentVNode("", true),
                  createVNode(_component_NuxtImg, {
                    src: unref(serverUrl) + "/thumbnails/" + _ctx.product.image,
                    class: "product-image",
                    format: "webp",
                    width: 200,
                    height: 200,
                    loading: "lazy",
                    alt: ""
                  }, null, 8, ["src"]),
                  createVNode(_component_ThemeSearchProductColors, {
                    class: "product-colors",
                    product: _ctx.product
                  }, null, 8, ["product"])
                ]),
                createVNode("div", { class: "flex flex-col justify-between w-full flex-grow" }, [
                  createVNode("div", { class: "title title-twl font-bold" }, toDisplayString(_ctx.product.title), 1),
                  createVNode("div", null, [
                    createVNode("div", { class: "w-full flex justify-end pt-3" }, [
                      createVNode(_component_CommentScore, { product: _ctx.product }, null, 8, ["product"])
                    ]),
                    unref(theme) == "mobile" ? (openBlock(), createBlock(_component_ThemeSearchProductPrice, {
                      key: 0,
                      product: _ctx.product,
                      class: "pt-3"
                    }, null, 8, ["product"])) : createCommentVNode("", true)
                  ])
                ])
              ], 2),
              unref(theme) != "mobile" ? (openBlock(), createBlock(_component_ThemeSearchProductPrice, {
                key: 1,
                product: _ctx.product
              }, null, 8, ["product"])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/search/ProductView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=ProductView-CNzvSvNo.mjs.map
