import { defineComponent, watch, unref, mergeProps, ref, resolveComponent, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderAttrs, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { u as useState, p as productStore } from './server.mjs';
import { s as specificationsStore } from './specifications-Vu5A47gN.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "DesktopView",
  __ssrInlineRender: true,
  props: {
    data: {}
  },
  setup(__props) {
    const showAll = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.data) {
        _push(`<div${ssrRenderAttrs(_attrs)}>`);
        if (Object.keys(_ctx.data).length > 0) {
          _push(`<div class="specifications py-8"><div class="header"><p class="text-black font-bold">\u0645\u0634\u062E\u0635\u0627\u062A</p></div><div class="body"><!--[-->`);
          ssrRenderList(Object.keys(_ctx.data), (key, index) => {
            _push(`<div class="flex items-center">`);
            if (unref(showAll) || !unref(showAll) && index < 7) {
              _push(`<!--[--><p class="specification-name">${ssrInterpolate(_ctx.data[key].key)}</p><div class="w-full specification-value"><!--[-->`);
              ssrRenderList(_ctx.data[key].values, (value, key2) => {
                _push(`<p>${ssrInterpolate(value)}</p>`);
              });
              _push(`<!--]--></div><!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]--></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (Object.keys(_ctx.data).length > 7) {
          _push(`<div class="text-blue-500 flex items-center cursor-pointer text-sm py-5">`);
          if (!unref(showAll)) {
            _push(`<span>\u0645\u0634\u0627\u0647\u062F\u0647 \u0628\u06CC\u0634\u062A\u0631</span>`);
          } else {
            _push(`<span>\u0645\u0634\u0627\u0647\u062F\u0647 \u06A9\u0645\u062A\u0631</span>`);
          }
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "fa-angle-left"],
            class: "px-1.5"
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/DesktopView.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "MobileView",
  __ssrInlineRender: true,
  props: {
    data: {}
  },
  setup(__props) {
    const store = productStore();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.data) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "pt-3 pb-6" }, _attrs))}><p class="font-bold">\u062C\u062F\u0648\u0644 \u0645\u0634\u062E\u0635\u0627\u062A</p><table class="w-full mt-3 !text-[13px]"><!--[-->`);
        ssrRenderList(Object.keys(_ctx.data), (key, index) => {
          _push(`<!--[-->`);
          if (index < 5 || unref(store).descriptionOffcanvas == "show") {
            _push(`<tr><th class="bg-gray-100 w-[100px] border-b text-center py-2 !font-normal">${ssrInterpolate(_ctx.data[key].key)}</th><td class="border-b p-2"><!--[-->`);
            ssrRenderList(_ctx.data[key].values, (value, key2) => {
              _push(`<span>${ssrInterpolate(value)}</span>`);
            });
            _push(`<!--]--></td></tr>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></table>`);
        if (Object.keys(_ctx.data).length > 5 && unref(store).descriptionOffcanvas == "hide") {
          _push(`<div class="flex justify-center mt-4"><button class="btn bg-gray-100 w-auto text-sm"> \u0645\u0634\u0627\u0647\u062F\u0647 \u0627\u062F\u0627\u0645\u0647 \u0645\u0634\u062E\u0635\u0627\u062A `);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "angle-left"],
            class: "pr-2"
          }, null, _parent));
          _push(`</button></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/MobileView.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Product",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const theme = useState("theme");
    const store = specificationsStore();
    watch(() => props.product, () => {
      if (props.product) {
        store.getData(props.product.id);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_SpecificationsDesktopView = _sfc_main$2;
      const _component_SpecificationsMobileView = _sfc_main$1;
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_SpecificationsDesktopView, mergeProps({
          data: unref(store).data
        }, _attrs), null, _parent));
      } else {
        _push(ssrRenderComponent(_component_SpecificationsMobileView, mergeProps({
          data: unref(store).data
        }, _attrs), null, _parent));
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/Product.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=Product-C6hi_VV_.mjs.map
