import { _ as _sfc_main$3 } from './NuxtImg-DBEieluz.mjs';
import { _ as __nuxt_component_3 } from './Skeleton-B5XQTW8R.mjs';
import { defineComponent, ref, mergeProps, unref, resolveComponent, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderAttrs, ssrInterpolate, ssrRenderAttr, ssrRenderList } from 'vue/server-renderer';
import { b as useRuntimeConfig, c as useNuxtApp, u as useState } from './server.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import './v3-CqizLg04.mjs';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "GridList",
  __ssrInlineRender: true,
  props: {
    setting: {},
    posts: {},
    loading: { type: Boolean }
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_NuxtImg = _sfc_main$3;
      const _component_Skeleton = __nuxt_component_3;
      if (_ctx.setting) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: _ctx.setting.className
        }, _attrs))}><div class="py-4 flex justify-between"><span class="font-bold text-lg">${ssrInterpolate(_ctx.setting.title)}</span>`);
        if (unref(shopSetting)["blog_domain"]) {
          _push(`<a${ssrRenderAttr("href", unref(shopSetting)["blog_domain"])} target="_blank" class="text-red-500 text-sm flex items-center"><span>\u0645\u0634\u0627\u0647\u062F\u0647 \u0647\u0645\u0647</span>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "angle-left"],
            class: "pr-4"
          }, null, _parent));
          _push(`</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="last-posts grid md: md:grid-cols-2 lg:grid-cols-4 gap-4"><!--[-->`);
        ssrRenderList(_ctx.posts, (post) => {
          _push(`<a class="bg-white rounded-lg border" target="_blank"${ssrRenderAttr("href", unref(shopSetting)["blog_domain"] + "/post/" + post.slug)}><div class="relative">`);
          _push(ssrRenderComponent(_component_NuxtImg, {
            alt: post.title,
            src: unref(serverUrl) + "/thumbnails/" + post.image,
            class: "w-full rounded-tr-lg h-[200px] rounded-tl-lg",
            heigth: 200,
            width: 300
          }, null, _parent));
          if (post.video_link) {
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "circle-play"],
              class: "absolute right-3 bottom-3 text-xl text-red-500"
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="p-4 leading-8 text-sm">${ssrInterpolate(post.title)}</div></a>`);
        });
        _push(`<!--]-->`);
        if (_ctx.loading) {
          _push(`<!--[-->`);
          ssrRenderList(4, (i) => {
            _push(`<div class="bg-white rounded-lg border">`);
            _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-36 rounded-tr-lg rounded-tl-lg" }, null, _parent));
            _push(`<div class="p-4">`);
            _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-2" }, null, _parent));
            _push(`</div></div>`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/blog/GridList.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Slider",
  __ssrInlineRender: true,
  props: {
    setting: {},
    posts: {},
    loading: { type: Boolean }
  },
  setup(__props) {
    const injectStyles = [
      `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:20px;
     height:20px;
     color:black;
  }`
    ];
    const shopSetting = useState("shopSetting");
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_NuxtImg = _sfc_main$3;
      const _component_Skeleton = __nuxt_component_3;
      if (_ctx.setting) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: _ctx.setting.className
        }, _attrs))}><div class="flex items-center justify-between py-3"><h1 class="font-bold">${ssrInterpolate(_ctx.setting.title)}</h1>`);
        if (unref(shopSetting)["blog_domain"]) {
          _push(`<a${ssrRenderAttr("href", unref(shopSetting)["blog_domain"])} target="_blank" class="text-red-500 text-sm flex items-center"><span>\u0645\u0634\u0627\u0647\u062F\u0647 \u0647\u0645\u0647</span>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "angle-left"],
            class: "pr-4"
          }, null, _parent));
          _push(`</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><swiper-container${ssrRenderAttr("navigation", true)}${ssrRenderAttr("injectStyles", injectStyles)} space-between="15"${ssrRenderAttr("breakpoints", {
          380: { slidesPerView: 2 },
          768: { slidesPerView: 3 },
          1024: { slidesPerView: 4 },
          1280: { slidesPerView: 5 }
        })}>`);
        if (!_ctx.loading) {
          _push(`<!--[-->`);
          ssrRenderList(_ctx.posts, (post, index) => {
            _push(`<swiper-slide class="w-auto h-auto"><a target="_blank"${ssrRenderAttr("href", unref(shopSetting)["blog_domain"] + "/post/" + post.slug)}><div class="relative">`);
            _push(ssrRenderComponent(_component_NuxtImg, {
              alt: post.title,
              src: unref(serverUrl) + "/thumbnails/" + post.image,
              class: "w-full rounded-tr-lg h-[150px] rounded-tl-lg",
              heigth: 150,
              width: 300
            }, null, _parent));
            if (post.video_link) {
              _push(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "circle-play"],
                class: "absolute right-3 bottom-3 text-xl text-red-500"
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</div><div class="p-4 leading-8 text-sm">${ssrInterpolate(post.title)}</div></a></swiper-slide>`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!--[-->`);
          ssrRenderList(10, (index) => {
            _push(`<swiper-slide class="w-auto h-auto"><div>`);
            _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-32 rounded-md" }, null, _parent));
            _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-2 my-3 rounded-md" }, null, _parent));
            _push(`</div></swiper-slide>`);
          });
          _push(`<!--]-->`);
        }
        _push(`</swiper-container></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/blog/Slider.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Posts",
  __ssrInlineRender: true,
  props: {
    setting: {}
  },
  setup(__props) {
    const posts = ref([]);
    const loading = ref(false);
    const { api } = useRuntimeConfig().public;
    const { $axios } = useNuxtApp();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_BlogGridList = _sfc_main$2;
      const _component_BlogSlider = _sfc_main$1;
      if (_ctx.setting.type == "grid") {
        _push(ssrRenderComponent(_component_BlogGridList, mergeProps({
          setting: _ctx.setting,
          posts: unref(posts),
          loading: unref(loading)
        }, _attrs), null, _parent));
      } else {
        _push(ssrRenderComponent(_component_BlogSlider, mergeProps({
          setting: _ctx.setting,
          posts: unref(posts),
          loading: unref(loading)
        }, _attrs), null, _parent));
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/blog/Posts.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=Posts-VtdKy7se.mjs.map
