import { _ as _sfc_main$3 } from './TextInput-BtVMT3NE.mjs';
import { LMap, LTileLayer, LControlZoom, LMarker, LIcon } from '@vue-leaflet/vue-leaflet';
import { defineComponent, ref, resolveComponent, createVNode, resolveDynamicComponent, unref, mergeProps, withCtx, createBlock, createCommentVNode, openBlock, watch, nextTick, computed, useSSRContext } from 'vue';
import { ssrRenderVNode, ssrRenderComponent, ssrRenderAttrs, ssrRenderList, ssrInterpolate, ssrRenderAttr } from 'vue/server-renderer';
import { p as publicAssetsURL } from '../_/nitro.mjs';
import { u as useState, _ as _sfc_main$i, a as _sfc_main$o, b as useRuntimeConfig, c as useNuxtApp, m as useFetch } from './server.mjs';
import { defineStore } from 'pinia';
import { _ as _sfc_main$4 } from './Component-C6QGchKb.mjs';
import { _ as _sfc_main$5 } from './SelectTag-Cc2QTMT4.mjs';

const addressStore = defineStore("address", () => {
  const addresses = ref([]);
  const loading = ref(false);
  const formBox = ref(null);
  const step = ref(1);
  const addressId = ref(0);
  const searchText = ref("");
  const searchLoading = ref(false);
  const apiKey = "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiIsImp0aSI6IjY0Y2IyY2FhOTUyZGI0NjUzZmZjZWI2MmIyNmFmODUwYWI4NWY2YTM3M2FiNDUzMzc0YTdiN2MzNWNlNDE3OWM3ZThiMGVlMzVkOGEyZWE1In0.eyJhdWQiOiIxOTY4MSIsImp0aSI6IjY0Y2IyY2FhOTUyZGI0NjUzZmZjZWI2MmIyNmFmODUwYWI4NWY2YTM3M2FiNDUzMzc0YTdiN2MzNWNlNDE3OWM3ZThiMGVlMzVkOGEyZWE1IiwiaWF0IjoxNjY1NTA1MDQzLCJuYmYiOjE2NjU1MDUwNDMsImV4cCI6MTY2ODAxMDY0Mywic3ViIjoiIiwic2NvcGVzIjpbImJhc2ljIl19.j8Ot6KjU-3QzKwid1nIsFTpY_X8ghbmVPgE0X_lzqbyYqpgfyJRvou5glbFZm1fitJTijEncAesYK7ydYBjSlbcFpbU0CnMpl1XrcF2gHjXz5DFYh7onL9KH4baQBnzGuNZkatj4p602_9MgBMK_nQCiWiuGl7rLm7cYVwgtsu3XOdksVjx0Rt-NS4LA2czAFy54nTbSM94H6y_beZ5LWkf5kIIX-vqdwELR-T-A1xKQG5T3Sv-9A4w7UXzqQs7dfuV6K_chQ1NahaqtfsGOqduk9KvsCNw9kQf6m1BWMpqCQFtE9Zgi_VcRnWifpcLLm9WmxRPfveOflLpNbUnmeA";
  const searchAddresses = ref([]);
  const location = ref([38.0718603, 46.2842501]);
  const formData = ref({});
  const { api } = useRuntimeConfig().public;
  const { $axios } = useNuxtApp();
  const getAddresses = () => {
    if (!loading.value) {
      loading.value = true;
      $axios.get(api + "/user/addresses").then((response) => {
        loading.value = false;
        addresses.value = response.data;
      }).catch(() => {
        loading.value = false;
      });
    }
  };
  const showCreateForm = function() {
    step.value = 1;
    formBox.value.show();
  };
  const showEditForm = (id) => {
    step.value = 1;
    addressId.value = id;
    const address = addresses.value.find((address2) => address2.id == id);
    if (address) {
      const selectedAddress = { ...{}, ...address };
      delete address.id;
      formData.value = selectedAddress;
      location.value = [
        selectedAddress.latitude,
        selectedAddress.longitude
      ];
    }
    nextTick(() => {
      formBox.value.show();
    });
  };
  const searchLocation = async function() {
    searchLoading.value = true;
    const { data: result, error } = await useFetch(
      "https://map.ir/search/v2/autocomplete?text=" + searchText.value + "&x-api-key=" + apiKey + "&select=City,Region,Neighborhood",
      "$SgAJshCNiR"
    );
    searchLoading.value = false;
    if (error.value == null) {
      searchAddresses.value = result.value.value;
    }
  };
  const selectAddressLocation = function(data) {
    if (data.geom !== void 0) {
      searchText.value = "";
      searchAddresses.value = [];
      location.value = [
        data.geom.coordinates[1],
        data.geom.coordinates[0]
      ];
    }
  };
  const removeAddress = (id) => {
    $axios.delete(api + "/user/address/" + id).then((response) => {
      if (response.data.status == "ok") {
        const index = addresses.value.findIndex((address) => address.id == id);
        if (index >= 0) {
          addresses.value.splice(index, 1);
        }
      }
    });
  };
  const updateStep = (value) => {
    step.value = value;
  };
  return {
    searchLoading,
    searchAddresses,
    step,
    location,
    searchText,
    addressId,
    formBox,
    loading,
    addresses,
    formData,
    apiKey,
    updateStep,
    removeAddress,
    selectAddressLocation,
    searchLocation,
    showCreateForm,
    showEditForm,
    getAddresses
  };
});
const _imports_0 = publicAssetsURL("/images/map_location.svg");
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "SelectLocation",
  __ssrInlineRender: true,
  setup(__props) {
    const store = addressStore();
    const map = ref(null);
    const zoom = ref(15);
    const readyMap = () => {
      setTimeout(() => {
        if (map.value !== null) {
          map.value.leafletObject.invalidateSize();
        }
      }, 200);
    };
    const changeMarkerPosition = () => {
      const geom = map.value.leafletObject.getCenter();
      store.location = [
        geom["lat"],
        geom["lng"]
      ];
    };
    watch(() => store.searchText, () => {
      if (store.searchLoading == false && store.searchText && store.searchText.toString().trim().length >= 3) {
        store.searchLocation();
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$3;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_LMap = LMap;
      const _component_LTileLayer = LTileLayer;
      const _component_LControlZoom = LControlZoom;
      const _component_LMarker = LMarker;
      const _component_LIcon = LIcon;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "location-box relative flex flex-col items-center" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_FormTextInput, {
        placeholder: "\u062C\u0633\u062A\u062C\u0648\u06CC \u0622\u062F\u0631\u0633",
        class: ["!absolute z-[1000] mt-1 w-[90%]", { "has-result": unref(store).searchAddresses }],
        modelValue: unref(store).searchText,
        "onUpdate:modelValue": ($event) => unref(store).searchText = $event
      }, {
        perfix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="pl-4 pr-2 h-full flex justify-center items-center"${_scopeId}>`);
            if (unref(store).searchText) {
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "arrow-right"],
                class: "cursor-pointer",
                onClick: ($event) => {
                  unref(store).searchText = "";
                  unref(store).searchAddresses = [];
                }
              }, null, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "search"] }, null, _parent2, _scopeId));
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "pl-4 pr-2 h-full flex justify-center items-center" }, [
                unref(store).searchText ? (openBlock(), createBlock(_component_fa_icon, {
                  key: 0,
                  icon: ["fas", "arrow-right"],
                  class: "cursor-pointer",
                  onClick: ($event) => {
                    unref(store).searchText = "";
                    unref(store).searchAddresses = [];
                  }
                }, null, 8, ["onClick"])) : (openBlock(), createBlock(_component_fa_icon, {
                  key: 1,
                  icon: ["fas", "search"]
                }))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(store).searchAddresses && unref(store).searchAddresses.length > 0) {
        _push(`<ul class="search-result border"><!--[-->`);
        ssrRenderList(unref(store).searchAddresses, (row, key) => {
          _push(`<!--[-->`);
          if (row.address !== void 0) {
            _push(`<li class="p-3 cursor-pointer">`);
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "location"],
              class: "px-1.5"
            }, null, _parent));
            _push(`<span class="px-3">${ssrInterpolate(row.address)}</span></li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></ul>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-full h-full">`);
      _push(ssrRenderComponent(_component_LMap, {
        dragging: false,
        onReady: ($event) => readyMap(),
        options: { zoomControl: false },
        center: unref(store).location,
        ref_key: "map",
        ref: map,
        zoom: unref(zoom),
        onDrag: ($event) => changeMarkerPosition(),
        "use-global-leaflet": false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_LTileLayer, {
              url: "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
              "layer-type": "base"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_LControlZoom, { position: "bottomleft" }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_LMarker, {
              "lat-lng": unref(store).location
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_LIcon, null, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`<img${ssrRenderAttr("src", _imports_0)} alt="loading"${_scopeId3}>`);
                      } else {
                        return [
                          createVNode("img", {
                            src: _imports_0,
                            alt: "loading"
                          })
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_LIcon, null, {
                      default: withCtx(() => [
                        createVNode("img", {
                          src: _imports_0,
                          alt: "loading"
                        })
                      ]),
                      _: 1
                    })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_LTileLayer, {
                url: "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
                "layer-type": "base"
              }),
              createVNode(_component_LControlZoom, { position: "bottomleft" }),
              createVNode(_component_LMarker, {
                "lat-lng": unref(store).location
              }, {
                default: withCtx(() => [
                  createVNode(_component_LIcon, null, {
                    default: withCtx(() => [
                      createVNode("img", {
                        src: _imports_0,
                        alt: "loading"
                      })
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              }, 8, ["lat-lng"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/SelectLocation.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
function useStepForm() {
  const store = addressStore();
  const provinces = useState("provinces");
  const cities = useState("cities");
  const formKey = ref(0);
  const form = ref(null);
  const { $axios } = useNuxtApp();
  const provinceName = ref(null);
  const cityName = ref(null);
  const provinceCities = computed(() => {
    if (store.formData.province_id) {
      return cities.value.filter((city) => city.province_id == store.formData.province_id);
    } else {
      return [];
    }
  });
  const submit = () => {
    form.value.sendForm();
  };
  watch(() => store.formData.province_id, () => {
    store.formData.city_id = null;
    formKey.value = formKey.value + 1;
  });
  watch(() => provinceName.value, () => {
    const province = provinces.value.find((row) => row.name == provinceName.value);
    if (province) {
      store.formData.province_id = province.id;
    }
  });
  watch(() => provinceCities.value, () => {
    if (cityName) {
      const city = provinceCities.value.find((row) => row.name == cityName.value);
      if (city) {
        store.formData.city_id = city.id;
      }
    }
  });
  return {
    store,
    form,
    submit,
    formKey,
    provinces,
    provinceCities
  };
}
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Form",
  __ssrInlineRender: true,
  props: {
    result: { type: Function }
  },
  setup(__props, { expose: __expose }) {
    const {
      submit,
      store,
      form,
      formKey,
      provinces,
      provinceCities
    } = useStepForm();
    __expose({
      submit
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormComponent = _sfc_main$4;
      const _component_FormTextInput = _sfc_main$3;
      const _component_FormSelectTag = _sfc_main$5;
      _push(ssrRenderComponent(_component_FormComponent, mergeProps({
        ref_key: "form",
        ref: form,
        "request-url": unref(store).addressId == 0 ? "user/address/create" : "user/address/" + unref(store).addressId,
        result: _ctx.result,
        key: unref(formKey)
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<input type="hidden" class="c-input" name="latitude"${ssrRenderAttr("value", unref(store).location[0])}${_scopeId}><input type="hidden" class="c-input" name="longitude"${ssrRenderAttr("value", unref(store).location[1])}${_scopeId}>`);
            if (unref(store).addressId != 0) {
              _push2(`<input type="hidden" class="c-input" name="_method" value="put"${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="flex flex-wrap"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_FormTextInput, {
              name: "address",
              label: "\u0622\u062F\u0631\u0633",
              modelValue: unref(store).formData.address,
              "onUpdate:modelValue": ($event) => unref(store).formData.address = $event,
              rules: ["required"],
              type: "textarea",
              class: "w-full"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormSelectTag, {
              items: unref(provinces),
              label: "\u0627\u0633\u062A\u0627\u0646",
              "item-text": "name",
              "item-value": "id",
              name: "province_id",
              rules: ["required"],
              modelValue: unref(store).formData.province_id,
              "onUpdate:modelValue": ($event) => unref(store).formData.province_id = $event,
              class: "w-full md:w-1/2"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormSelectTag, {
              items: unref(provinceCities),
              label: "\u0634\u0647\u0631",
              "item-text": "name",
              modelValue: unref(store).formData.city_id,
              "onUpdate:modelValue": ($event) => unref(store).formData.city_id = $event,
              "item-value": "id",
              name: "city_id",
              rules: ["required"],
              class: "w-full md:w-1/2"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u067E\u0644\u0627\u06A9",
              name: "plaque",
              type: "number",
              rules: ["required"],
              modelValue: unref(store).formData.plaque,
              "onUpdate:modelValue": ($event) => unref(store).formData.plaque = $event,
              class: "w-1/2"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u0648\u0627\u062D\u062F",
              name: "unit",
              type: "number",
              rules: ["required"],
              modelValue: unref(store).formData.unit,
              "onUpdate:modelValue": ($event) => unref(store).formData.unit = $event,
              class: "w-1/2"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u06A9\u062F \u067E\u0633\u062A\u06CC",
              name: "postalCode",
              type: "number",
              rules: ["required"],
              modelValue: unref(store).formData.postalCode,
              "onUpdate:modelValue": ($event) => unref(store).formData.postalCode = $event,
              class: "w-full"
            }, null, _parent2, _scopeId));
            _push2(`<div class="w-full"${_scopeId}><div class="text-xs base-space !py-0"${_scopeId}> \u06A9\u062F\u200C\u067E\u0633\u062A\u06CC \u0628\u0627\u06CC\u062F \u06F1\u06F0 \u0631\u0642\u0645 \u0648 \u0628\u062F\u0648\u0646 \u062E\u0637 \u062A\u06CC\u0631\u0647 \u0628\u0627\u0634\u062F. </div></div>`);
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u0646\u0627\u0645 \u06AF\u06CC\u0631\u0646\u062F\u0647",
              name: "recipient_name",
              rules: ["required"],
              modelValue: unref(store).formData.recipient_name,
              "onUpdate:modelValue": ($event) => unref(store).formData.recipient_name = $event,
              class: "w-full md:w-1/2"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u0646\u0627\u0645 \u062E\u0627\u0646\u0648\u0627\u062F\u06AF\u06CC \u06AF\u06CC\u0631\u0646\u062F\u0647",
              name: "recipient_last_name",
              rules: ["required"],
              modelValue: unref(store).formData.recipient_last_name,
              "onUpdate:modelValue": ($event) => unref(store).formData.recipient_last_name = $event,
              class: "w-full md:w-1/2"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_FormTextInput, {
              label: "\u0634\u0645\u0627\u0631\u0647 \u0645\u0648\u0628\u0627\u06CC\u0644",
              name: "recipient_mobile_number",
              rules: ["required"],
              modelValue: unref(store).formData.recipient_mobile_number,
              "onUpdate:modelValue": ($event) => unref(store).formData.recipient_mobile_number = $event,
              class: "w-full md:w-1/2"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("input", {
                type: "hidden",
                class: "c-input",
                name: "latitude",
                value: unref(store).location[0]
              }, null, 8, ["value"]),
              createVNode("input", {
                type: "hidden",
                class: "c-input",
                name: "longitude",
                value: unref(store).location[1]
              }, null, 8, ["value"]),
              unref(store).addressId != 0 ? (openBlock(), createBlock("input", {
                key: 0,
                type: "hidden",
                class: "c-input",
                name: "_method",
                value: "put"
              })) : createCommentVNode("", true),
              createVNode("div", { class: "flex flex-wrap" }, [
                createVNode(_component_FormTextInput, {
                  name: "address",
                  label: "\u0622\u062F\u0631\u0633",
                  modelValue: unref(store).formData.address,
                  "onUpdate:modelValue": ($event) => unref(store).formData.address = $event,
                  rules: ["required"],
                  type: "textarea",
                  class: "w-full"
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormSelectTag, {
                  items: unref(provinces),
                  label: "\u0627\u0633\u062A\u0627\u0646",
                  "item-text": "name",
                  "item-value": "id",
                  name: "province_id",
                  rules: ["required"],
                  modelValue: unref(store).formData.province_id,
                  "onUpdate:modelValue": ($event) => unref(store).formData.province_id = $event,
                  class: "w-full md:w-1/2"
                }, null, 8, ["items", "modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormSelectTag, {
                  items: unref(provinceCities),
                  label: "\u0634\u0647\u0631",
                  "item-text": "name",
                  modelValue: unref(store).formData.city_id,
                  "onUpdate:modelValue": ($event) => unref(store).formData.city_id = $event,
                  "item-value": "id",
                  name: "city_id",
                  rules: ["required"],
                  class: "w-full md:w-1/2"
                }, null, 8, ["items", "modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormTextInput, {
                  label: "\u067E\u0644\u0627\u06A9",
                  name: "plaque",
                  type: "number",
                  rules: ["required"],
                  modelValue: unref(store).formData.plaque,
                  "onUpdate:modelValue": ($event) => unref(store).formData.plaque = $event,
                  class: "w-1/2"
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormTextInput, {
                  label: "\u0648\u0627\u062D\u062F",
                  name: "unit",
                  type: "number",
                  rules: ["required"],
                  modelValue: unref(store).formData.unit,
                  "onUpdate:modelValue": ($event) => unref(store).formData.unit = $event,
                  class: "w-1/2"
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormTextInput, {
                  label: "\u06A9\u062F \u067E\u0633\u062A\u06CC",
                  name: "postalCode",
                  type: "number",
                  rules: ["required"],
                  modelValue: unref(store).formData.postalCode,
                  "onUpdate:modelValue": ($event) => unref(store).formData.postalCode = $event,
                  class: "w-full"
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode("div", { class: "w-full" }, [
                  createVNode("div", { class: "text-xs base-space !py-0" }, " \u06A9\u062F\u200C\u067E\u0633\u062A\u06CC \u0628\u0627\u06CC\u062F \u06F1\u06F0 \u0631\u0642\u0645 \u0648 \u0628\u062F\u0648\u0646 \u062E\u0637 \u062A\u06CC\u0631\u0647 \u0628\u0627\u0634\u062F. ")
                ]),
                createVNode(_component_FormTextInput, {
                  label: "\u0646\u0627\u0645 \u06AF\u06CC\u0631\u0646\u062F\u0647",
                  name: "recipient_name",
                  rules: ["required"],
                  modelValue: unref(store).formData.recipient_name,
                  "onUpdate:modelValue": ($event) => unref(store).formData.recipient_name = $event,
                  class: "w-full md:w-1/2"
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormTextInput, {
                  label: "\u0646\u0627\u0645 \u062E\u0627\u0646\u0648\u0627\u062F\u06AF\u06CC \u06AF\u06CC\u0631\u0646\u062F\u0647",
                  name: "recipient_last_name",
                  rules: ["required"],
                  modelValue: unref(store).formData.recipient_last_name,
                  "onUpdate:modelValue": ($event) => unref(store).formData.recipient_last_name = $event,
                  class: "w-full md:w-1/2"
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode(_component_FormTextInput, {
                  label: "\u0634\u0645\u0627\u0631\u0647 \u0645\u0648\u0628\u0627\u06CC\u0644",
                  name: "recipient_mobile_number",
                  rules: ["required"],
                  modelValue: unref(store).formData.recipient_mobile_number,
                  "onUpdate:modelValue": ($event) => unref(store).formData.recipient_mobile_number = $event,
                  class: "w-full md:w-1/2"
                }, null, 8, ["modelValue", "onUpdate:modelValue"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/Form.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "CreateOrEdit",
  __ssrInlineRender: true,
  setup(__props) {
    const store = addressStore();
    const formBox = ref(null);
    const form = ref(null);
    const toast = useState("toast");
    const theme = useState("theme");
    const result = () => {
      formBox.value.hide();
      store.formData = {};
      if (store.addressId > 0) {
        toast.value = {
          message: "\u0648\u06CC\u0631\u0627\u06CC\u0634 \u0622\u062F\u0631\u0633 \u0628\u0627 \u0645\u0648\u0641\u0642\u06CC\u062A \u0627\u0646\u062C\u0627\u0645 \u0634\u062F",
          type: "success"
        };
      }
      store.addressId = 0;
      store.getAddresses();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_AddressesSelectLocation = _sfc_main$2;
      const _component_AddressesForm = _sfc_main$1;
      const _component_fa_icon = resolveComponent("fa-icon");
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i : _sfc_main$o), mergeProps({
        ref_key: "formBox",
        ref: formBox,
        "content-class": "w-full !h-full bottom-0",
        direction: "bottom",
        class: ["address-form", "address-form-" + unref(store).step],
        title: unref(store).addressId == 0 ? "\u0622\u062F\u0631\u0633 \u062C\u062F\u06CC\u062F" : "\u0648\u06CC\u0631\u0627\u06CC\u0634 \u0622\u062F\u0631\u0633",
        "sub-title": unref(store).step == 1 ? " \u0645\u0648\u0642\u0639\u06CC\u062A \u0645\u06A9\u0627\u0646\u06CC \u0622\u062F\u0631\u0633 \u0631\u0627 \u0645\u0634\u062E\u0635 \u06A9\u0646\u06CC\u062F." : "\u062C\u0632\u06CC\u06CC\u0627\u062A \u0622\u062F\u0631\u0633"
      }, _attrs), {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(store).step == 1) {
              _push2(`<div class="flex justify-between items-center border-t p-3"${_scopeId}><span${_scopeId}> \u0645\u0631\u0633\u0648\u0644\u0647\u200C\u0647\u0627\u06CC \u0634\u0645\u0627 \u0628\u0647 \u0627\u06CC\u0646 \u0645\u0648\u0642\u0639\u06CC\u062A \u0627\u0631\u0633\u0627\u0644 \u062E\u0648\u0627\u0647\u062F \u0634\u062F. </span><button class="c-btn px-3"${_scopeId}><span${_scopeId}>\u062A\u0627\u06CC\u06CC\u062F \u0648 \u0627\u062F\u0627\u0645\u0647</span>`);
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "fa-angle-left"],
                class: "pr-2"
              }, null, _parent2, _scopeId));
              _push2(`</button></div>`);
            } else {
              _push2(`<div class="p-3 border-t"${_scopeId}><button class="c-btn w-full"${_scopeId}>`);
              if (unref(store).addressId == 0) {
                _push2(`<span${_scopeId}>\u062B\u0628\u062A \u0622\u062F\u0631\u0633</span>`);
              } else {
                _push2(`<span${_scopeId}>\u0648\u06CC\u0631\u0627\u06CC\u0634 \u0622\u062F\u0631\u0633</span>`);
              }
              _push2(`</button></div>`);
            }
          } else {
            return [
              unref(store).step == 1 ? (openBlock(), createBlock("div", {
                key: 0,
                class: "flex justify-between items-center border-t p-3"
              }, [
                createVNode("span", null, " \u0645\u0631\u0633\u0648\u0644\u0647\u200C\u0647\u0627\u06CC \u0634\u0645\u0627 \u0628\u0647 \u0627\u06CC\u0646 \u0645\u0648\u0642\u0639\u06CC\u062A \u0627\u0631\u0633\u0627\u0644 \u062E\u0648\u0627\u0647\u062F \u0634\u062F. "),
                createVNode("button", {
                  class: "c-btn px-3",
                  onClick: ($event) => unref(store).updateStep(2)
                }, [
                  createVNode("span", null, "\u062A\u0627\u06CC\u06CC\u062F \u0648 \u0627\u062F\u0627\u0645\u0647"),
                  createVNode(_component_fa_icon, {
                    icon: ["fas", "fa-angle-left"],
                    class: "pr-2"
                  })
                ], 8, ["onClick"])
              ])) : (openBlock(), createBlock("div", {
                key: 1,
                class: "p-3 border-t"
              }, [
                createVNode("button", {
                  class: "c-btn w-full",
                  onClick: ($event) => {
                    var _a;
                    return (_a = unref(form)) == null ? void 0 : _a.submit();
                  }
                }, [
                  unref(store).addressId == 0 ? (openBlock(), createBlock("span", { key: 0 }, "\u062B\u0628\u062A \u0622\u062F\u0631\u0633")) : (openBlock(), createBlock("span", { key: 1 }, "\u0648\u06CC\u0631\u0627\u06CC\u0634 \u0622\u062F\u0631\u0633"))
                ], 8, ["onClick"])
              ]))
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(store).step == 1) {
              _push2(ssrRenderComponent(_component_AddressesSelectLocation, null, null, _parent2, _scopeId));
            } else if (unref(store).step == 2) {
              _push2(ssrRenderComponent(_component_AddressesForm, {
                ref_key: "form",
                ref: form,
                result
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(store).step == 1 ? (openBlock(), createBlock(_component_AddressesSelectLocation, { key: 0 })) : unref(store).step == 2 ? (openBlock(), createBlock(_component_AddressesForm, {
                key: 1,
                ref_key: "form",
                ref: form,
                result
              }, null, 512)) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }), _parent);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/CreateOrEdit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _, addressStore as a };
//# sourceMappingURL=CreateOrEdit-LLCfqsZZ.mjs.map
