import { ref, provide, mergeProps, defineComponent, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderSlot, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { c as clearUserData } from './user-utils-B9JSuaai.mjs';
import { c as useNuxtApp, b as useRuntimeConfig, n as navigateTo } from './server.mjs';

const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ServerErrors",
  __ssrInlineRender: true,
  props: {
    errors: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.errors.length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "alert alert-warning my-2 px-5 py-3 leading-8" }, _attrs))}><ul><!--[-->`);
        ssrRenderList(_ctx.errors, (error, key) => {
          _push(`<li>${ssrInterpolate(error)}</li>`);
        });
        _push(`<!--]--></ul></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ServerErrors.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {
  __name: "Component",
  __ssrInlineRender: true,
  props: {
    method: { type: String, default: "post" },
    result: Function,
    requestUrl: String,
    sendFunction: Function,
    completionData: Function,
    csrf: { type: Boolean },
    sendFile: Boolean
  },
  setup(__props, { expose: __expose }) {
    const props = __props;
    const { $axios } = useNuxtApp();
    const form = ref(null);
    const rules = ref([]);
    const errors = ref([]);
    const loading = ref(false);
    const isValid = ref(false);
    function addRule(fun) {
      rules.value.push(fun);
    }
    function sendForm() {
      const isValid2 = rules.value.every((rule) => rule() === true);
      if (isValid2) submitForm();
    }
    const submitForm = async () => {
      const inputs = form.value.querySelectorAll(".c-input");
      const data = {};
      let sendFile = props.sendFile;
      inputs.forEach((input) => {
        const name = input.getAttribute("name");
        let value = input.getAttribute("value");
        if (input.type === "file" && input.files[0]) {
          value = input.files[0];
          sendFile = true;
        }
        data[name] = value;
      });
      if (props.sendFunction) {
        props.sendFunction(data);
      } else {
        const url = `${useRuntimeConfig().public.api}/${props.requestUrl}`;
        props.method === "get" ? await sendGetRequest(url, data) : await sendPostRequest(url, data, sendFile);
      }
    };
    const sendGetRequest = async (url, data) => {
      errors.value = [];
      const queryParams = new URLSearchParams(data).toString();
      const fullUrl = url + (url.includes("?") ? "&" : "?") + queryParams;
      try {
        const response = await $axios.get(fullUrl);
        props.result(response);
      } catch (error) {
      }
    };
    const sendPostRequest = async (url, data, sendFile) => {
      if (props.completionData) data = props.completionData(data);
      errors.value = [];
      if (data) {
        try {
          changeLoadingStatus(true);
          if (props.csrf) {
            await $axios.get(useRuntimeConfig().public.serverUrl + "/sanctum/csrf-cookie");
          }
          const response = await $axios.post(url, data, {
            headers: sendFile ? { "Content-Type": "multipart/form-data" } : {}
          });
          props.result(response);
        } catch (error) {
          errors.value = useNuxtApp().vueApp.config.globalProperties.$serverErrors(error);
          if (error && error.status && error.status === 401) {
            clearUserData();
            navigateTo("/login");
          }
        } finally {
          changeLoadingStatus(false);
        }
      }
    };
    const changeLoadingStatus = (value) => {
      loading.value = value;
    };
    provide("addRule", addRule);
    provide("sendForm", sendForm);
    provide("loading", loading);
    __expose({
      submitForm,
      sendForm,
      isValid,
      loading
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ServerErrors = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        ref_key: "form",
        ref: form
      }, _attrs))}>`);
      _push(ssrRenderComponent(_component_ServerErrors, { errors: unref(errors) }, null, _parent));
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/Component.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=Component-C6QGchKb.mjs.map
