import { h as _sfc_main$k } from './server.mjs';
import { inject, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';

const _sfc_main = {
  __name: "Button",
  __ssrInlineRender: true,
  props: ["className"],
  setup(__props) {
    const loading = inject("loading");
    inject("sendForm");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$k;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "base-space" }, _attrs))}><button type="button" class="${ssrRenderClass([__props.className, "btn"])}">`);
      if (unref(loading)) {
        _push(`<div class="w-full flex items-center justify-center">`);
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
        _push(`</div>`);
      } else {
        ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      }
      _push(`</button></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/Button.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=Button-CglX5dCL.mjs.map
