import{aO as ae}from"./BICM-vNf.js";var oe={exports:{}};/**
 * @license Highstock JS v11.4.8 (2024-08-29)
 *
 * All technical indicators for Highcharts Stock
 *
 * (c) 2010-2024 Pawel Fus
 *
 * License: www.highcharts.com/license
 */var se;function re(){return se||(se=1,function(ie){(function(q){ie.exports?(q.default=q,ie.exports=q):q(typeof Highcharts<"u"?Highcharts:void 0)})(function(q){var S=q?q._modules:{};function R(A,P,v,T){A.hasOwnProperty(P)||(A[P]=T.apply(null,v),typeof CustomEvent=="function"&&q.win.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:P,module:A[P]}})))}R(S,"Stock/Indicators/SMA/SMAIndicator.js",[S["Core/Chart/Chart.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{line:T}=P.seriesTypes,{addEvent:M,fireEvent:L,error:C,extend:I,isArray:m,merge:x,pick:o,splat:r}=v;class e extends T{destroy(){this.dataEventsToUnbind.forEach(function(t){t()}),super.destroy.apply(this,arguments)}getName(){const t=[];let n=this.name;return n||((this.nameComponents||[]).forEach(function(l,g){t.push(this.options.params[l]+o(this.nameSuffixes[g],""))},this),n=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+t.join(", ")+")":"")),n}getValues(t,n){const l=n.period,g=t.xData,h=t.yData,p=h.length,c=[],s=[],a=[];let u,d=-1,y=0,D,f=0;if(!(g.length<l)){for(m(h[0])&&(d=n.index?n.index:0);y<l-1;)f+=d<0?h[y]:h[y][d],y++;for(u=y;u<p;u++)f+=d<0?h[u]:h[u][d],D=[g[u],f/l],c.push(D),s.push(D[0]),a.push(D[1]),f-=d<0?h[u-y]:h[u-y][d];return{values:c,xData:s,yData:a}}}init(t,n){const l=this;super.init.call(l,t,n);const g=M(A,"afterLinkSeries",function({isUpdating:h}){if(h)return;const p=!!l.dataEventsToUnbind.length;if(l.linkedParent){if(p||(l.dataEventsToUnbind.push(M(l.linkedParent,"updatedData",function(){l.recalculateValues()})),l.calculateOn.xAxis&&l.dataEventsToUnbind.push(M(l.linkedParent.xAxis,l.calculateOn.xAxis,function(){l.recalculateValues()}))),l.calculateOn.chart==="init")l.processedYData||l.recalculateValues();else if(!p){const c=M(l.chart,l.calculateOn.chart,function(){l.recalculateValues(),c()})}}else return C("Series "+l.options.linkedTo+" not found! Check `linkedTo`.",!1,t)},{order:0});l.dataEventsToUnbind=[],l.eventsToUnbind.push(g)}recalculateValues(){const t=[],n=this,l=n.points||[],g=(n.xData||[]).length,h={values:[],xData:[],yData:[]};let p=!0,c,s,a,u,d,y;const D=n.linkedParent.options&&n.linkedParent.yData&&n.linkedParent.yData.length&&n.getValues(n.linkedParent,n.options.params)||h;if(g&&!n.hasGroupedData&&n.visible&&n.points)if(n.cropped){for(n.xAxis&&(u=n.xAxis.min,d=n.xAxis.max),a=n.cropData(D.xData,D.yData,u,d),y=0;y<a.xData.length;y++)t.push([a.xData[y]].concat(r(a.yData[y])));c=D.xData.indexOf(n.xData[0]),s=D.xData.indexOf(n.xData[n.xData.length-1]),c===-1&&s===D.xData.length-2&&t[0][0]===l[0].x&&t.shift(),n.updateData(t)}else(n.updateAllPoints||D.xData.length!==g-1&&D.xData.length!==g+1)&&(p=!1,n.updateData(D.values));p&&(n.xData=D.xData,n.yData=D.yData,n.options.data=D.values),n.calculateOn.xAxis&&n.processedXData&&(delete n.processedXData,n.isDirty=!0,n.redraw()),n.isDirtyData=!!n.linkedSeries.length,L(n,"updatedData")}processData(){const t=this,n=t.options.compareToMain,l=t.linkedParent;super.processData.apply(t,arguments),t.dataModify&&l&&l.dataModify&&l.dataModify.compareValue&&n&&(t.dataModify.compareValue=l.dataModify.compareValue)}}return e.defaultOptions=x(T.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:3,period:14}}),I(e.prototype,{calculateOn:{chart:"init"},hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],useCommonDataGrouping:!0}),P.registerSeriesType("sma",e),e}),R(S,"Stock/Indicators/EMA/EMAIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{correctFloat:T,isArray:M,merge:L}=P;class C extends v{accumulatePeriodPoints(m,x,o){let r=0,e=0,i=0;for(;e<m;)i=x<0?o[e]:o[e][x],r=r+i,e++;return r}calculateEma(m,x,o,r,e,i,t){const n=m[o-1],l=i<0?x[o-1]:x[o-1][i],g=typeof e>"u"?t:T(l*r+e*(1-r));return[n,g]}getValues(m,x){const o=x.period,r=m.xData,e=m.yData,i=e?e.length:0,t=2/(o+1),n=[],l=[],g=[];let h,p,c,s=-1,a=0,u=0;if(!(i<o)){for(M(e[0])&&(s=x.index?x.index:0),a=this.accumulatePeriodPoints(o,s,e),u=a/o,c=o;c<i+1;c++)p=this.calculateEma(r,e,c,t,h,s,u),n.push(p),l.push(p[0]),g.push(p[1]),h=p[1];return{values:n,xData:l,yData:g}}}}return C.defaultOptions=L(v.defaultOptions,{params:{index:3,period:9}}),A.registerSeriesType("ema",C),C}),R(S,"Stock/Indicators/AD/ADIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{error:T,extend:M,merge:L}=P;class C extends v{static populateAverage(m,x,o,r,e){const i=x[r][1],t=x[r][2],n=x[r][3],l=o[r],g=n===i&&n===t||i===t?0:(2*n-t-i)/(i-t)*l;return[m[r],g]}getValues(m,x){const o=x.period,r=m.xData,e=m.yData,i=x.volumeSeriesID,t=m.chart.get(i),n=t&&t.yData,l=e?e.length:0,g=[],h=[],p=[];let c,s,a;if(!(r.length<=o&&l&&e[0].length!==4)){if(!t){T("Series "+i+" not found! Check `volumeSeriesID`.",!0,m.chart);return}for(s=o;s<l;s++)c=g.length,a=C.populateAverage(r,e,n,s,o),c>0&&(a[1]+=g[c-1][1]),g.push(a),h.push(a[0]),p.push(a[1]);return{values:g,xData:h,yData:p}}}}return C.defaultOptions=L(v.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}}),M(C.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"}),A.registerSeriesType("ad",C),C}),R(S,"Stock/Indicators/AO/AOIndicator.js",[S["Core/Globals.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{noop:T}=A,{column:{prototype:M},sma:L}=P.seriesTypes,{extend:C,merge:I,correctFloat:m,isArray:x}=v;class o extends L{drawGraph(){const e=this,i=e.options,t=e.points,n=e.userOptions.color,l=i.greaterBarColor,g=i.lowerBarColor,h=t[0];let p;if(!n&&h)for(h.color=l,p=1;p<t.length;p++)t[p].y>t[p-1].y?t[p].color=l:t[p].y<t[p-1].y?t[p].color=g:t[p].color=t[p-1].color}getValues(e){const n=e.xData||[],l=e.yData||[],g=l.length,h=[],p=[],c=[],s=1,a=2;let u,d,y,D,f,V,k,j,b=0,O=0;if(!(n.length<=34||!x(l[0])||l[0].length!==4)){for(k=0;k<33;k++)V=(l[k][s]+l[k][a])/2,k>=29&&(O=m(O+V)),b=m(b+V);for(j=33;j<g;j++)V=(l[j][s]+l[j][a])/2,O=m(O+V),b=m(b+V),u=O/5,d=b/34,y=m(u-d),h.push([n[j],y]),p.push(n[j]),c.push(y),D=j+1-5,f=j+1-34,O=m(O-(l[D][s]+l[D][a])/2),b=m(b-(l[f][s]+l[f][a])/2);return{values:h,xData:p,yData:c}}}}return o.defaultOptions=I(L.defaultOptions,{params:{index:void 0,period:void 0},greaterBarColor:"#06b535",lowerBarColor:"#f21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}}),C(o.prototype,{nameBase:"AO",nameComponents:void 0,markerAttribs:T,getColumnMetrics:M.getColumnMetrics,crispCol:M.crispCol,translate:M.translate,drawPoints:M.drawPoints}),P.registerSeriesType("ao",o),o}),R(S,"Stock/Indicators/MultipleLinesComposition.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:{prototype:v}}=A.seriesTypes,{defined:T,error:M,merge:L}=P;var C;return function(I){const m=["bottomLine"],x=["top","bottom"],o=["top"],r="top";function e(p){const c=p.prototype;return c.linesApiNames=c.linesApiNames||m.slice(),c.pointArrayMap=c.pointArrayMap||x.slice(),c.pointValKey=c.pointValKey||r,c.areaLinesNames=c.areaLinesNames||o.slice(),c.drawGraph=n,c.getGraphPath=l,c.toYData=g,c.translate=h,p}I.compose=e;function i(p){return"plot"+p.charAt(0).toUpperCase()+p.slice(1)}function t(p,c){const s=[];return(p.pointArrayMap||[]).forEach(a=>{a!==c&&s.push(i(a))}),s}function n(){const p=this,c=p.pointValKey,s=p.linesApiNames,a=p.areaLinesNames,u=p.points,d=p.options,y=p.graph,D={options:{gapSize:d.gapSize}},f=[],V=t(p,c);let k=u.length,j;if(V.forEach((b,O)=>{for(f[O]=[];k--;)j=u[k],f[O].push({x:j.x,plotX:j.plotX,plotY:j[b],isNull:!T(j[b])});k=u.length}),p.userOptions.fillColor&&a.length){const b=V.indexOf(i(a[0])),O=f[b],B=a.length===1?u:f[V.indexOf(i(a[1]))],w=p.color;p.points=B,p.nextPoints=O,p.color=p.userOptions.fillColor,p.options=L(u,D),p.graph=p.area,p.fillGraph=!0,v.drawGraph.call(p),p.area=p.graph,delete p.nextPoints,delete p.fillGraph,p.color=w}s.forEach((b,O)=>{f[O]?(p.points=f[O],d[b]?p.options=L(d[b].styles,D):M('Error: "There is no '+b+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names."'),p.graph=p["graph"+b],v.drawGraph.call(p),p["graph"+b]=p.graph):M('Error: "'+b+` doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap."`)}),p.points=u,p.options=d,p.graph=y,v.drawGraph.call(p)}function l(p){let c,s=[],a=[];if(p=p||this.points,this.fillGraph&&this.nextPoints){if(c=v.getGraphPath.call(this,this.nextPoints),c&&c.length){c[0][0]="L",s=v.getGraphPath.call(this,p),a=c.slice(0,s.length);for(let u=a.length-1;u>=0;u--)s.push(a[u])}}else s=v.getGraphPath.apply(this,arguments);return s}function g(p){const c=[];return(this.pointArrayMap||[]).forEach(s=>{c.push(p[s])}),c}function h(){const p=this.pointArrayMap;let c=[],s;c=t(this),v.translate.apply(this,arguments),this.points.forEach(a=>{p.forEach((u,d)=>{s=a[u],this.dataModify&&(s=this.dataModify.modifyValue(s)),s!==null&&(a[c[d]]=this.yAxis.toPixels(s,!0))})})}}(C||(C={})),C}),R(S,"Stock/Indicators/Aroon/AroonIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{extend:M,merge:L,pick:C}=v;function I(x,o){let r=x[0],e=0,i;for(i=1;i<x.length;i++)(o==="max"&&x[i]>=r||o==="min"&&x[i]<=r)&&(r=x[i],e=i);return e}class m extends T{getValues(o,r){const e=r.period,i=o.xData,t=o.yData,n=t?t.length:0,l=[],g=[],h=[],p=2,c=1;let s,a,u,d,y,D;for(y=e-1;y<n;y++)D=t.slice(y-e+1,y+2),u=I(D.map(function(f){return C(f[p],f)}),"min"),d=I(D.map(function(f){return C(f[c],f)}),"max"),s=d/e*100,a=u/e*100,i[y+1]&&(l.push([i[y+1],s,a]),g.push(i[y+1]),h.push([s,a]));return{values:l,xData:g,yData:h}}}return m.defaultOptions=L(T.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}}),M(m.prototype,{areaLinesNames:[],linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y"}),A.compose(m),P.registerSeriesType("aroon",m),m}),R(S,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{aroon:T}=P.seriesTypes,{extend:M,merge:L}=v;class C extends T{getValues(m,x){const o=[],r=[],e=[];let i,t,n,l;const g=super.getValues.call(this,m,x);for(l=0;l<g.yData.length;l++)i=g.yData[l][0],t=g.yData[l][1],n=i-t,o.push([g.xData[l],n]),r.push(g.xData[l]),e.push(n);return{values:o,xData:r,yData:e}}}return C.defaultOptions=L(T.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b>: {point.y}'}}),M(C.prototype,{nameBase:"Aroon Oscillator",linesApiNames:[],pointArrayMap:["y"],pointValKey:"y"}),A.compose(T),P.registerSeriesType("aroonoscillator",C),C}),R(S,"Stock/Indicators/ATR/ATRIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isArray:T,merge:M}=P;function L(x,o,r,e){const i=o[e],t=r[e];x.push([i,t])}function C(x,o){const r=x,e=o,i=r[1]-r[2],t=typeof e>"u"?0:Math.abs(r[1]-e[3]),n=typeof e>"u"?0:Math.abs(r[2]-e[3]);return Math.max(i,t,n)}function I(x,o,r,e,i,t){const n=o[e-1],l=C(r[e-1],r[e-2]),g=(t*(i-1)+l)/i;return[n,g]}class m extends v{getValues(o,r){const e=r.period,i=o.xData,t=o.yData,n=t?t.length:0,l=i[0],g=t[0],h=[[l,g]],p=[],c=[],s=[];let a,u,d=0,y=1,D=0;if(!(i.length<=e||!T(t[0])||t[0].length!==4)){for(u=1;u<=n;u++)L(h,i,t,u),e<y?(a=I(h,i,t,u,e,d),d=a[1],p.push(a),c.push(a[0]),s.push(a[1])):e===y?(d=D/(u-1),p.push([i[u-1],d]),c.push(i[u-1]),s.push(d),y++):(D+=C(t[u-1],t[u-2]),y++);return{values:p,xData:c,yData:s}}}}return m.defaultOptions=M(v.defaultOptions,{params:{index:void 0}}),A.registerSeriesType("atr",m),m}),R(S,"Stock/Indicators/BB/BBIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{extend:M,isArray:L,merge:C}=v;function I(x,o,r,e){const i=x.length;let t=0,n=0,l,g=0;for(;t<i;t++)l=(r?x[t][o]:x[t])-e,g+=l*l;return g=g/(i-1),n=Math.sqrt(g),n}class m extends T{init(){P.seriesTypes.sma.prototype.init.apply(this,arguments),this.options=C({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)}getValues(o,r){const e=r.period,i=r.standardDeviation,t=[],n=[],l=o.xData,g=o.yData,h=g?g.length:0,p=[];let c,s,a,u,d,y,D,f,V;if(l.length<e)return;const k=L(g[0]);for(V=e;V<=h;V++)d=l.slice(V-e,V),y=g.slice(V-e,V),f=P.seriesTypes.sma.prototype.getValues.call(this,{xData:d,yData:y},r),u=f.xData[0],c=f.yData[0],D=I(y,r.index,k,c),s=c+i*D,a=c-i*D,p.push([u,s,c,a]),t.push(u),n.push([s,c,a]);return{values:p,xData:t,yData:n}}}return m.defaultOptions=C(T.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}}),M(m.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameComponents:["period","standardDeviation"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),A.compose(m),P.registerSeriesType("bb",m),m}),R(S,"Stock/Indicators/CCI/CCIIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isArray:T,merge:M}=P;function L(m){return m.reduce(function(x,o){return x+o},0)}function C(m,x){const o=m.length;let r=0,e;for(e=0;e<o;e++)r+=Math.abs(x-m[e]);return r}class I extends v{getValues(x,o){const r=o.period,e=x.xData,i=x.yData,t=i?i.length:0,n=[],l=[],g=[],h=[];let p,c,s=[],a,u=1,d,y,D,f;if(!(e.length<=r||!T(i[0])||i[0].length!==4)){for(;u<r;)c=i[u-1],n.push((c[1]+c[2]+c[3])/3),u++;for(f=r;f<=t;f++)c=i[f-1],y=(c[1]+c[2]+c[3])/3,a=n.push(y),s=n.slice(a-r),d=L(s)/r,D=C(s,d)/r,p=(y-d)/(.015*D),l.push([e[f-1],p]),g.push(e[f-1]),h.push(p);return{values:l,xData:g,yData:h}}}}return I.defaultOptions=M(v.defaultOptions,{params:{index:void 0}}),A.registerSeriesType("cci",I),I}),R(S,"Stock/Indicators/CMF/CMFIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{merge:T}=P;class M extends v{constructor(){super(...arguments),this.nameBase="Chaikin Money Flow"}isValid(){const C=this.chart,I=this.options,m=this.linkedParent,x=this.volumeSeries||(this.volumeSeries=C.get(I.params.volumeSeriesID)),o=m&&m.yData&&m.yData[0].length===4;function r(e){return e.xData&&e.xData.length>=I.params.period}return!!(m&&x&&r(m)&&r(x)&&o)}getValues(C,I){if(this.isValid())return this.getMoneyFlow(C.xData,C.yData,this.volumeSeries.yData,I.period)}getMoneyFlow(C,I,m,x){const o=I.length,r=[],e=[],i=[],t=[];let n,l,g=-1,h=0,p=0;function c(s,a){const u=s[1],d=s[2],y=s[3],D=a!==null&&u!==null&&d!==null&&y!==null&&u!==d;function f(V,k,j){return(j-k-(V-j))/(V-k)}return D?f(u,d,y)*a:(g=n,null)}if(x>0&&x<=o){for(n=0;n<x;n++)r[n]=c(I[n],m[n]),h+=m[n],p+=r[n];for(e.push(C[n-1]),i.push(n-g>=x&&h!==0?p/h:null),t.push([e[0],i[0]]);n<o;n++)r[n]=c(I[n],m[n]),h-=m[n-x],h+=m[n],p-=r[n-x],p+=r[n],l=[C[n],n-g>=x?p/h:null],e.push(l[0]),i.push(l[1]),t.push([l[0],l[1]])}return{values:t,xData:e,yData:i}}}return M.defaultOptions=T(v.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}}),A.registerSeriesType("cmf",M),M}),R(S,"Stock/Indicators/DMI/DMIIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{correctFloat:M,extend:L,isArray:C,merge:I}=v;class m extends T{calculateDM(o,r,e){const i=o[r][1],t=o[r][2],n=o[r-1][1],l=o[r-1][2];let g;return i-n>l-t?g=e?Math.max(i-n,0):0:g=e?0:Math.max(l-t,0),M(g)}calculateDI(o,r){return o/r*100}calculateDX(o,r){return M(Math.abs(o-r)/Math.abs(o+r)*100)}smoothValues(o,r,e){return M(o-o/e+r)}getTR(o,r){return M(Math.max(o[1]-o[2],r?Math.abs(o[1]-r[3]):0,r?Math.abs(o[2]-r[3]):0))}getValues(o,r){const e=r.period,i=o.xData,t=o.yData,n=t?t.length:0,l=[],g=[],h=[];if(i.length<=e||!C(t[0])||t[0].length!==4)return;let p=0,c=0,s=0,a;for(a=1;a<n;a++){let u,d,y,D,f,V,k,j,b;a<=e?(D=this.calculateDM(t,a,!0),f=this.calculateDM(t,a),V=this.getTR(t[a],t[a-1]),p+=D,c+=f,s+=V,a===e&&(k=this.calculateDI(p,s),j=this.calculateDI(c,s),b=this.calculateDX(p,c),l.push([i[a],b,k,j]),g.push(i[a]),h.push([b,k,j]))):(D=this.calculateDM(t,a,!0),f=this.calculateDM(t,a),V=this.getTR(t[a],t[a-1]),u=this.smoothValues(p,D,e),d=this.smoothValues(c,f,e),y=this.smoothValues(s,V,e),p=u,c=d,s=y,k=this.calculateDI(p,s),j=this.calculateDI(c,s),b=this.calculateDX(p,c),l.push([i[a],b,k,j]),g.push(i[a]),h.push([b,k,j]))}return{values:l,xData:g,yData:h}}}return m.defaultOptions=I(T.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">●</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}}),L(m.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"}),A.compose(m),P.registerSeriesType("dmi",m),m}),R(S,"Stock/Indicators/DPO/DPOIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{extend:T,merge:M,correctFloat:L,pick:C}=P;function I(x,o,r,e,i){const t=C(o[r][e],o[r]);return L(i?x-t:x+t)}class m extends v{getValues(o,r){const e=r.period,i=r.index,t=Math.floor(e/2+1),n=e+t,l=o.xData||[],g=o.yData||[],h=g.length,p=[],c=[],s=[];let a,u,d,y,D,f,V=0;if(!(l.length<=n)){for(D=0;D<e-1;D++)V=I(V,g,D,i);for(f=0;f<=h-n;f++)u=f+e-1,d=f+n-1,V=I(V,g,u,i),y=C(g[d][i],g[d]),a=y-V/e,V=I(V,g,f,i,!0),p.push([l[d],a]),c.push(l[d]),s.push(a);return{values:p,xData:c,yData:s}}}}return m.defaultOptions=M(v.defaultOptions,{params:{index:0,period:21}}),T(m.prototype,{nameBase:"DPO"}),A.registerSeriesType("dpo",m),m}),R(S,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[S["Stock/Indicators/AD/ADIndicator.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{ema:T}=P.seriesTypes,{correctFloat:M,extend:L,merge:C,error:I}=v;class m extends T{getValues(o,r){const e=r.periods,i=r.period,t=[],n=[],l=[];let g,h;if(e.length!==2||e[1]<=e[0]){I('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');return}const p=A.prototype.getValues.call(this,o,{volumeSeriesID:r.volumeSeriesID,period:i});if(!p)return;const c=super.getValues.call(this,p,{period:e[0]}),s=super.getValues.call(this,p,{period:e[1]});if(!c||!s)return;const a=e[1]-e[0];for(h=0;h<s.yData.length;h++)g=M(c.yData[h+a]-s.yData[h]),t.push([s.xData[h],g]),n.push(s.xData[h]),l.push(g);return{values:t,xData:n,yData:l}}}return m.defaultOptions=C(T.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}}),L(m.prototype,{nameBase:"Chaikin Osc",nameComponents:["periods"]}),P.registerSeriesType("chaikin",m),m}),R(S,"Stock/Indicators/CMO/CMOIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isNumber:T,merge:M}=P;class L extends v{getValues(I,m){const x=m.period,o=I.xData,r=I.yData,e=r?r.length:0,i=[],t=[],n=[];let l,g=m.index,h;if(o.length<x)return;T(r[0])?h=r:(g=Math.min(g,r[0].length-1),h=r.map(u=>u[g]));let p=0,c=0,s=0,a;for(let u=x;u>0;u--)h[u]>h[u-1]?c+=h[u]-h[u-1]:h[u]<h[u-1]&&(s+=h[u-1]-h[u]);for(a=c+s>0?100*(c-s)/(c+s):0,t.push(o[x]),n.push(a),i.push([o[x],a]),l=x+1;l<e;l++)p=Math.abs(h[l-x-1]-h[l-x]),h[l]>h[l-1]?c+=h[l]-h[l-1]:h[l]<h[l-1]&&(s+=h[l-1]-h[l]),h[l-x]>h[l-x-1]?c-=p:s-=p,a=c+s>0?100*(c-s)/(c+s):0,t.push(o[l]),n.push(a),i.push([o[l],a]);return{values:i,xData:t,yData:n}}}return L.defaultOptions=M(v.defaultOptions,{params:{period:20,index:3}}),A.registerSeriesType("cmo",L),L}),R(S,"Stock/Indicators/DEMA/DEMAIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{ema:v}=A.seriesTypes,{correctFloat:T,isArray:M,merge:L}=P;class C extends v{getEMA(m,x,o,r,e,i){return super.calculateEma(i||[],m,typeof e>"u"?1:e,this.EMApercent,x,typeof r>"u"?-1:r,o)}getValues(m,x){const o=x.period,r=[],e=2*o,i=m.xData,t=m.yData,n=t?t.length:0,l=[],g=[],h=[];let p=0,c=0,s,a,u,d,y=-1,D,f=0;if(this.EMApercent=2/(o+1),!(n<2*o-1)){for(M(t[0])&&(y=x.index?x.index:0),p=super.accumulatePeriodPoints(o,y,t),f=p/o,p=0,d=o;d<n+2;d++)d<n+1&&(c=this.getEMA(t,a,f,y,d)[1],r.push(c)),a=c,d<e?p+=c:(d===e&&(f=p/o),c=r[d-o-1],s=this.getEMA([c],u,f)[1],D=[i[d-2],T(2*c-s)],l.push(D),g.push(D[0]),h.push(D[1]),u=s);return{values:l,xData:g,yData:h}}}}return C.defaultOptions=L(v.defaultOptions),A.registerSeriesType("dema",C),C}),R(S,"Stock/Indicators/TEMA/TEMAIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{ema:v}=A.seriesTypes,{correctFloat:T,isArray:M,merge:L}=P;class C extends v{getEMA(m,x,o,r,e,i){return super.calculateEma(i||[],m,typeof e>"u"?1:e,this.EMApercent,x,typeof r>"u"?-1:r,o)}getTemaPoint(m,x,o,r){return[m[r-3],T(3*o.level1-3*o.level2+o.level3)]}getValues(m,x){const o=x.period,r=2*o,e=3*o,i=m.xData,t=m.yData,n=t?t.length:0,l=[],g=[],h=[],p=[],c=[],s={};let a=-1,u=0,d=0,y,D,f,V;if(this.EMApercent=2/(o+1),!(n<3*o-2)){for(M(t[0])&&(a=x.index?x.index:0),u=super.accumulatePeriodPoints(o,a,t),d=u/o,u=0,f=o;f<n+3;f++)f<n+1&&(s.level1=this.getEMA(t,y,d,a,f)[1],p.push(s.level1)),y=s.level1,f<r?u+=s.level1:(f===r&&(d=u/o,u=0),s.level1=p[f-o-1],s.level2=this.getEMA([s.level1],D,d)[1],c.push(s.level2),D=s.level2,f<e?u+=s.level2:(f===e&&(d=u/o),f===n+1&&(s.level1=p[f-o-1],s.level2=this.getEMA([s.level1],D,d)[1],c.push(s.level2)),s.level1=p[f-o-2],s.level2=c[f-2*o-1],s.level3=this.getEMA([s.level2],s.prevLevel3,d)[1],V=this.getTemaPoint(i,e,s,f),V&&(l.push(V),g.push(V[0]),h.push(V[1])),s.prevLevel3=s.level3));return{values:l,xData:g,yData:h}}}}return C.defaultOptions=L(v.defaultOptions),A.registerSeriesType("tema",C),C}),R(S,"Stock/Indicators/TRIX/TRIXIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{tema:v}=A.seriesTypes,{correctFloat:T,merge:M}=P;class L extends v{getTemaPoint(I,m,x,o){if(o>m)return[I[o-3],x.prevLevel3!==0?T(x.level3-x.prevLevel3)/x.prevLevel3*100:null]}}return L.defaultOptions=M(v.defaultOptions),A.registerSeriesType("trix",L),L}),R(S,"Stock/Indicators/APO/APOIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{ema:v}=A.seriesTypes,{extend:T,merge:M,error:L}=P;class C extends v{getValues(m,x){const o=x.periods,r=x.index,e=[],i=[],t=[];let n,l;if(o.length!==2||o[1]<=o[0]){L('Error: "APO requires two periods. Notice, first period should be lower than the second one."');return}const g=super.getValues.call(this,m,{index:r,period:o[0]}),h=super.getValues.call(this,m,{index:r,period:o[1]});if(!g||!h)return;const p=o[1]-o[0];for(l=0;l<h.yData.length;l++)n=g.yData[l+p]-h.yData[l],e.push([h.xData[l],n]),i.push(h.xData[l]),t.push(n);return{values:e,xData:i,yData:t}}}return C.defaultOptions=M(v.defaultOptions,{params:{period:void 0,periods:[10,20]}}),T(C.prototype,{nameBase:"APO",nameComponents:["periods"]}),A.registerSeriesType("apo",C),C}),R(S,"Stock/Indicators/IKH/IKHIndicator.js",[S["Extensions/DataGrouping/ApproximationRegistry.js"],S["Core/Color/Color.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v,T){const{parse:M}=P,{sma:L}=v.seriesTypes,{defined:C,extend:I,isArray:m,isNumber:x,getClosestDistance:o,merge:r,objectEach:e}=T;function i(c){return c.reduce(function(s,a){return Math.max(s,a[1])},-1/0)}function t(c){return c.reduce(function(s,a){return Math.min(s,a[2])},1/0)}function n(c){return{high:i(c),low:t(c)}}function l(c,s,a,u){if(c&&s&&a&&u){const d=s.plotX-c.plotX,y=s.plotY-c.plotY,D=u.plotX-a.plotX,f=u.plotY-a.plotY,V=c.plotX-a.plotX,k=c.plotY-a.plotY,j=(-y*V+d*k)/(-D*y+d*f),b=(D*k-f*V)/(-D*y+d*f);if(j>=0&&j<=1&&b>=0&&b<=1)return{plotX:c.plotX+b*d,plotY:c.plotY+b*y}}}function g(c){const s=c.indicator;s.points=c.points,s.nextPoints=c.nextPoints,s.color=c.color,s.options=r(c.options.senkouSpan.styles,c.gap),s.graph=c.graph,s.fillGraph=!0,v.seriesTypes.sma.prototype.drawGraph.call(s)}function h(){const c=[];let s;return[].forEach.call(arguments,function(a,u){c.push(A.average(a)),s=!s&&typeof c[u]>"u"}),s?void 0:c}class p extends L{constructor(){super(...arguments),this.data=[],this.options={},this.points=[],this.graphCollection=[]}init(){super.init.apply(this,arguments),this.options=r({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:M(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:M(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:M(this.color).setOpacity(.2).get()}}},this.options)}toYData(s){return[s.tenkanSen,s.kijunSen,s.chikouSpan,s.senkouSpanA,s.senkouSpanB]}translate(){const s=this;v.seriesTypes.sma.prototype.translate.apply(s);for(const a of s.points)for(const u of s.pointArrayMap){const d=a[u];x(d)&&(a["plot"+u]=s.yAxis.toPixels(d,!0),a.plotY=a["plot"+u],a.tooltipPos=[a.plotX,a["plot"+u]],a.isNull=!1)}}drawGraph(){const s=this,a=s.points,u=s.options,d=s.graph,y=s.color,D={options:{gapSize:u.gapSize}},f=s.pointArrayMap.length,V=[[],[],[],[],[],[]],k={tenkanLine:V[0],kijunLine:V[1],chikouLine:V[2],senkouSpanA:V[3],senkouSpanB:V[4],senkouSpan:V[5]},j=[],b=s.options.senkouSpan,O=b.color||b.styles.fill,B=b.negativeColor,w=[[],[]],N=[[],[]];let U=a.length,E=0,X,Y,F,_,z,G,H,$,J,te,K,Q,ee;for(s.ikhMap=k;U--;){for(Y=a[U],F=0;F<f;F++)X=s.pointArrayMap[F],C(Y[X])&&V[F].push({plotX:Y.plotX,plotY:Y["plot"+X],isNull:!1});if(B&&U!==a.length-1){const W=k.senkouSpanB.length-1,Z=l(k.senkouSpanA[W-1],k.senkouSpanA[W],k.senkouSpanB[W-1],k.senkouSpanB[W]);if(Z){const ne={plotX:Z.plotX,plotY:Z.plotY,isNull:!1,intersectPoint:!0};k.senkouSpanA.splice(W,0,ne),k.senkouSpanB.splice(W,0,ne),j.push(W)}}}if(e(k,(W,Z)=>{u[Z]&&Z!=="senkouSpan"&&(s.points=V[E],s.options=r(u[Z].styles,D),s.graph=s["graph"+Z],s.fillGraph=!1,s.color=y,v.seriesTypes.sma.prototype.drawGraph.call(s),s["graph"+Z]=s.graph),E++}),s.graphCollection)for(const W of s.graphCollection)s[W].destroy(),delete s[W];if(s.graphCollection=[],B&&k.senkouSpanA[0]&&k.senkouSpanB[0]){for(j.unshift(0),j.push(k.senkouSpanA.length-1),Q=0;Q<j.length-1;Q++)if(_=j[Q],z=j[Q+1],G=k.senkouSpanB.slice(_,z+1),H=k.senkouSpanA.slice(_,z+1),Math.floor(G.length/2)>=1){const W=Math.floor(G.length/2);if(G[W].plotY===H[W].plotY){for($=0,J=0,ee=0;ee<G.length;ee++)$+=G[ee].plotY,J+=H[ee].plotY;K=$>J?0:1,w[K]=w[K].concat(G),N[K]=N[K].concat(H)}else K=G[W].plotY>H[W].plotY?0:1,w[K]=w[K].concat(G),N[K]=N[K].concat(H)}else K=G[0].plotY>H[0].plotY?0:1,w[K]=w[K].concat(G),N[K]=N[K].concat(H);["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(W,Z){w[Z].length&&N[Z].length&&(te=Z===0?O:B,g({indicator:s,points:w[Z],nextPoints:N[Z],color:te,options:u,gap:D,graph:s[W]}),s[W]=s.graph,s.graphCollection.push(W))})}else g({indicator:s,points:k.senkouSpanB,nextPoints:k.senkouSpanA,color:O,options:u,gap:D,graph:s.graphsenkouSpan}),s.graphsenkouSpan=s.graph;delete s.nextPoints,delete s.fillGraph,s.points=a,s.options=u,s.graph=d,s.color=y}getGraphPath(s){const a=this;let u=[],d,y=[];if(s=s||this.points,a.fillGraph&&a.nextPoints){if(d=v.seriesTypes.sma.prototype.getGraphPath.call(a,a.nextPoints),d&&d.length){d[0][0]="L",u=v.seriesTypes.sma.prototype.getGraphPath.call(a,s),y=d.slice(0,u.length);for(let D=y.length-1;D>=0;D--)u.push(y[D])}}else u=v.seriesTypes.sma.prototype.getGraphPath.apply(a,arguments);return u}getValues(s,a){const u=a.period,d=a.periodTenkan,y=a.periodSenkouSpanB,D=s.xData,f=s.yData,V=s.xAxis,k=f&&f.length||0,j=o(V.series.map(te=>te.xData||[])),b=[],O=[];let B,w,N,U,E,X,Y,F,_,z,G,H,$;if(D.length<=u||!m(f[0])||f[0].length!==4)return;const J=D[0]-u*j;for(F=0;F<u;F++)O.push(J+F*j);for(F=0;F<k;F++)F>=d&&(w=f.slice(F-d,F),E=n(w),_=(E.high+E.low)/2),F>=u&&(N=f.slice(F-u,F),X=n(N),z=(X.high+X.low)/2,H=(_+z)/2),F>=y&&(U=f.slice(F-y,F),Y=n(U),$=(Y.high+Y.low)/2),G=f[F][3],B=D[F],typeof b[F]>"u"&&(b[F]=[]),typeof b[F+u-1]>"u"&&(b[F+u-1]=[]),b[F+u-1][0]=_,b[F+u-1][1]=z,b[F+u-1][2]=void 0,typeof b[F+1]>"u"&&(b[F+1]=[]),b[F+1][2]=G,F<=u&&(b[F+u-1][3]=void 0,b[F+u-1][4]=void 0),typeof b[F+2*u-2]>"u"&&(b[F+2*u-2]=[]),b[F+2*u-2][3]=H,b[F+2*u-2][4]=$,O.push(B);for(F=1;F<=u;F++)O.push(B+F*j);return{values:b,xData:O,yData:b}}}return p.defaultOptions=r(L.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}}),I(p.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period","periodTenkan"]}),A["ichimoku-averages"]=h,v.registerSeriesType("ikh",p),p}),R(S,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{correctFloat:M,extend:L,merge:C}=v;class I extends T{init(){P.seriesTypes.sma.prototype.init.apply(this,arguments),this.options=C({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)}getValues(x,o){const r=o.period,e=o.periodATR,i=o.multiplierATR,t=o.index,n=x.yData,l=n?n.length:0,g=[],h=P.seriesTypes.ema.prototype.getValues(x,{period:r,index:t}),p=P.seriesTypes.atr.prototype.getValues(x,{period:e}),c=[],s=[];let a,u,d,y,D,f,V;if(!(l<r)){for(V=r;V<=l;V++)D=h.values[V-r],f=p.values[V-e],y=D[0],u=M(D[1]+i*f[1]),d=M(D[1]-i*f[1]),a=D[1],g.push([y,u,a,d]),c.push(y),s.push([u,a,d]);return{values:g,xData:c,yData:s}}}}return I.defaultOptions=C(T.defaultOptions,{params:{index:0,period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1}),L(I.prototype,{nameBase:"Keltner Channels",areaLinesNames:["top","bottom"],nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),A.compose(I),P.registerSeriesType("keltnerchannels",I),I}),R(S,"Stock/Indicators/Klinger/KlingerIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{ema:T,sma:M}=P.seriesTypes,{correctFloat:L,error:C,extend:I,isArray:m,merge:x}=v;class o extends M{calculateTrend(e,i){return e[i][1]+e[i][2]+e[i][3]>e[i-1][1]+e[i-1][2]+e[i-1][3]?1:-1}isValidData(e){const i=this.chart,t=this.options,n=this.linkedParent,l=m(e)&&e.length===4,g=this.volumeSeries||(this.volumeSeries=i.get(t.params.volumeSeriesID));return g||C("Series "+t.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,n.chart),!!([n,g].every(function(p){return p&&p.xData&&p.xData.length>=t.params.slowAvgPeriod})&&l)}getCM(e,i,t,n,l){return L(i+(t===n?e:l))}getDM(e,i){return L(e-i)}getVolumeForce(e){const i=[];let t=0,n,l,g=1,h=0,p=e[0][1]-e[0][2],c=0,s;for(g;g<e.length;g++)s=this.calculateTrend(e,g),n=this.getDM(e[g][1],e[g][2]),t=this.getCM(h,n,s,c,p),l=this.volumeSeries.yData[g]*s*Math.abs(2*(n/t-1))*100,i.push([l]),c=s,h=t,p=n;return i}getEMA(e,i,t,n,l,g,h){return T.prototype.calculateEma(h||[],e,typeof g>"u"?1:g,n,i,typeof l>"u"?-1:l,t)}getSMA(e,i,t){return T.prototype.accumulatePeriodPoints(e,i,t)/e}getValues(e,i){const t=[],n=e.xData,l=e.yData,g=[],h=[],p=[];let c,s=0,a=0,u,d,y,D=null;if(!this.isValidData(l[0]))return;const f=this.getVolumeForce(l),V=this.getSMA(i.fastAvgPeriod,0,f),k=this.getSMA(i.slowAvgPeriod,0,f),j=2/(i.fastAvgPeriod+1),b=2/(i.slowAvgPeriod+1);for(s;s<l.length;s++)s>=i.fastAvgPeriod&&(a=this.getEMA(f,d,V,j,0,s,n)[1],d=a),s>=i.slowAvgPeriod&&(u=this.getEMA(f,y,k,b,0,s,n)[1],y=u,c=L(a-u),p.push(c),p.length>=i.signalPeriod&&(D=p.slice(-i.signalPeriod).reduce((O,B)=>O+B)/i.signalPeriod),t.push([n[s],c,D]),g.push(n[s]),h.push([c,D]));return{values:t,xData:g,yData:h}}}return o.defaultOptions=x(M.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">●</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}}),I(o.prototype,{areaLinesNames:[],linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y"}),A.compose(o),P.registerSeriesType("klinger",o),o}),R(S,"Stock/Indicators/MACD/MACDIndicator.js",[S["Core/Globals.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{noop:T}=A,{column:M,sma:L}=P.seriesTypes,{extend:C,correctFloat:I,defined:m,merge:x}=v;class o extends L{init(){P.seriesTypes.sma.prototype.init.apply(this,arguments);const e=this.color;this.options&&(m(this.colorIndex)&&(this.options.signalLine&&this.options.signalLine.styles&&!this.options.signalLine.styles.lineColor&&(this.options.colorIndex=this.colorIndex+1,this.getCyclic("color",void 0,this.chart.options.colors),this.options.signalLine.styles.lineColor=this.color),this.options.macdLine&&this.options.macdLine.styles&&!this.options.macdLine.styles.lineColor&&(this.options.colorIndex=this.colorIndex+1,this.getCyclic("color",void 0,this.chart.options.colors),this.options.macdLine.styles.lineColor=this.color)),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length}),this.color=e}toYData(e){return[e.y,e.signal,e.MACD]}translate(){const e=this,i=["plotSignal","plotMACD"];A.seriesTypes.column.prototype.translate.apply(e),e.points.forEach(function(t){[t.signal,t.MACD].forEach(function(n,l){n!==null&&(t[i[l]]=e.yAxis.toPixels(n,!0))})})}destroy(){this.graph=null,this.graphmacd=this.graphmacd&&this.graphmacd.destroy(),this.graphsignal=this.graphsignal&&this.graphsignal.destroy(),P.seriesTypes.sma.prototype.destroy.apply(this,arguments)}drawGraph(){const e=this,i=e.points,t=e.options,n=e.zones,l={options:{gapSize:t.gapSize}},g=[[],[]];let h,p=i.length;for(;p--;)h=i[p],m(h.plotMACD)&&g[0].push({plotX:h.plotX,plotY:h.plotMACD,isNull:!m(h.plotMACD)}),m(h.plotSignal)&&g[1].push({plotX:h.plotX,plotY:h.plotSignal,isNull:!m(h.plotMACD)});["macd","signal"].forEach((c,s)=>{var a;e.points=g[s],e.options=x(((a=t[`${c}Line`])==null?void 0:a.styles)||{},l),e.graph=e[`graph${c}`],e.zones=(e[`${c}Zones`].zones||[]).slice(e[`${c}Zones`].startIndex||0),P.seriesTypes.sma.prototype.drawGraph.call(e),e[`graph${c}`]=e.graph}),e.points=i,e.options=t,e.zones=n}applyZones(){const e=this.zones;this.zones=this.signalZones.zones,P.seriesTypes.sma.prototype.applyZones.call(this),this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide(),this.zones=e}getValues(e,i){const t=i.longPeriod-i.shortPeriod,n=[],l=[],g=[];let h,p,c,s=0,a=[];if(!(e.xData.length<i.longPeriod+i.signalPeriod)){for(h=P.seriesTypes.ema.prototype.getValues(e,{period:i.shortPeriod,index:i.index}),p=P.seriesTypes.ema.prototype.getValues(e,{period:i.longPeriod,index:i.index}),h=h.values,p=p.values,c=0;c<=h.length;c++)m(p[c])&&m(p[c][1])&&m(h[c+t])&&m(h[c+t][0])&&n.push([h[c+t][0],0,null,h[c+t][1]-p[c][1]]);for(c=0;c<n.length;c++)l.push(n[c][0]),g.push([0,null,n[c][3]]);for(a=P.seriesTypes.ema.prototype.getValues({xData:l,yData:g},{period:i.signalPeriod,index:2}),a=a.values,c=0;c<n.length;c++)n[c][0]>=a[0][0]&&(n[c][2]=a[s][1],g[c]=[0,a[s][1],n[c][3]],n[c][3]===null?(n[c][1]=0,g[c][0]=0):(n[c][1]=I(n[c][3]-a[s][1]),g[c][0]=I(n[c][3]-a[s][1])),s++);return{values:n,xData:l,yData:g}}}}return o.defaultOptions=x(L.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0}),C(o.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:T,getColumnMetrics:A.seriesTypes.column.prototype.getColumnMetrics,crispCol:A.seriesTypes.column.prototype.crispCol,drawPoints:A.seriesTypes.column.prototype.drawPoints}),P.registerSeriesType("macd",o),o}),R(S,"Stock/Indicators/MFI/MFIIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{extend:T,merge:M,error:L,isArray:C}=P;function I(e){return e.reduce(function(i,t){return i+t})}function m(e,i){return parseFloat(e.toFixed(i))}function x(e){return(e[1]+e[2]+e[3])/3}function o(e,i){return e*i}class r extends v{getValues(i,t){const n=t.period,l=i.xData,g=i.yData,h=g?g.length:0,p=t.decimals,c=i.chart.get(t.volumeSeriesID),s=c&&c.yData,a=[],u=[],d=[],y=[],D=[];let f,V,k,j,b,O,B,w,N=!1,U=1;if(!c){L("Series "+t.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,i.chart);return}if(!(l.length<=n||!C(g[0])||g[0].length!==4||!s)){for(f=x(g[U]);U<n+1;)V=f,f=x(g[U]),N=f>=V,k=o(f,s[U]),y.push(N?k:0),D.push(N?0:k),U++;for(w=U-1;w<h;w++)w>U-1&&(y.shift(),D.shift(),V=f,f=x(g[w]),N=f>V,k=o(f,s[w]),y.push(N?k:0),D.push(N?0:k)),j=I(D),b=I(y),O=b/j,B=m(100-100/(1+O),p),a.push([l[w],B]),u.push(l[w]),d.push(B);return{values:a,xData:u,yData:d}}}}return r.defaultOptions=M(v.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}}),T(r.prototype,{nameBase:"Money Flow Index"}),A.registerSeriesType("mfi",r),r}),R(S,"Stock/Indicators/Momentum/MomentumIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{extend:T,isArray:M,merge:L}=P;function C(m,x,o,r,e){const i=x[o-1][e]-x[o-r-1][e];return[m[o-1],i]}class I extends v{getValues(x,o){const r=o.period,e=o.index,i=x.xData,t=x.yData,n=t?t.length:0,l=[],g=[],h=[];let p,c;if(!(i.length<=r)&&M(t[0])){for(p=r+1;p<n;p++)c=C(i,t,p,r,e),l.push(c),g.push(c[0]),h.push(c[1]);return c=C(i,t,p,r,e),l.push(c),g.push(c[0]),h.push(c[1]),{values:l,xData:g,yData:h}}}}return I.defaultOptions=L(v.defaultOptions,{params:{index:3}}),T(I.prototype,{nameBase:"Momentum"}),A.registerSeriesType("momentum",I),I}),R(S,"Stock/Indicators/NATR/NATRIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{atr:v}=A.seriesTypes,{merge:T}=P;class M extends v{getValues(C,I){const m=super.getValues.apply(this,arguments),x=m.values.length,o=C.yData;let r=0,e=I.period-1;if(m){for(;r<x;r++)m.yData[r]=m.values[r][1]/o[e][3]*100,m.values[r][1]=m.yData[r],e++;return m}}}return M.defaultOptions=T(v.defaultOptions,{tooltip:{valueSuffix:"%"}}),A.registerSeriesType("natr",M),M}),R(S,"Stock/Indicators/OBV/OBVIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isNumber:T,error:M,extend:L,merge:C}=P;class I extends v{getValues(x,o){const r=x.chart.get(o.volumeSeriesID),e=x.xData,i=x.yData,t=[],n=[],l=[],g=!T(i[0]);let h=[],p=1,c=0,s=0,a=0,u=0,d;if(r)for(d=r.yData,h=[e[0],c],a=g?i[0][3]:i[0],t.push(h),n.push(e[0]),l.push(h[1]),p;p<i.length;p++)u=g?i[p][3]:i[p],u>a?s=c+d[p]:u===a?s=c:s=c-d[p],h=[e[p],s],c=s,a=u,t.push(h),n.push(e[p]),l.push(h[1]);else{M("Series "+o.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,x.chart);return}return{values:t,xData:n,yData:l}}}return I.defaultOptions=C(v.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}}),L(I.prototype,{nameComponents:void 0}),A.registerSeriesType("obv",I),I}),R(S,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[S["Core/Series/SeriesRegistry.js"]],function(A){const P=A.seriesTypes.sma.prototype.pointClass;function v(M,L){const C=M.series.pointArrayMap;let I,m=C.length;for(A.seriesTypes.sma.prototype.pointClass.prototype[L].call(M);m--;)I="dataLabel"+C[m],M[I]&&M[I].element&&M[I].destroy(),M[I]=null}class T extends P{destroyElements(){v(this,"destroyElements")}destroy(){v(this,"destroyElements")}}return T}),R(S,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[S["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{merge:M,extend:L,defined:C,isArray:I}=v;class m extends T{toYData(o){return[o.P]}translate(){const o=this;super.translate.apply(o),o.points.forEach(function(r){o.pointArrayMap.forEach(function(e){C(r[e])&&(r["plot"+e]=o.yAxis.toPixels(r[e],!0))})}),o.plotEndPoint=o.xAxis.toPixels(o.endPoint,!0)}getGraphPath(o){const r=this,e=[[],[],[],[],[],[],[],[],[]],i=r.pointArrayMap.length;let t=r.plotEndPoint,n=[],l,g,h=o.length,p;for(;h--;){for(g=o[h],p=0;p<i;p++)l=r.pointArrayMap[p],C(g[l])&&e[p].push({plotX:g.plotX,plotY:g["plot"+l],isNull:!1},{plotX:t,plotY:g["plot"+l],isNull:!1},{plotX:t,plotY:null,isNull:!0});t=g.plotX}return e.forEach(c=>{n=n.concat(super.getGraphPath.call(r,c))}),n}drawDataLabels(){const o=this,r=o.pointArrayMap;let e,i,t,n;o.options.dataLabels.enabled&&(i=o.points.length,r.concat([!1]).forEach((l,g)=>{for(n=i;n--;)t=o.points[n],l?(t.y=t[l],t.pivotLine=l,t.plotY=t["plot"+l],e=t["dataLabel"+l],g&&(t["dataLabel"+r[g-1]]=t.dataLabel),t.dataLabels||(t.dataLabels=[]),t.dataLabels[0]=t.dataLabel=e=e&&e.element?e:null):t["dataLabel"+r[g-1]]=t.dataLabel;super.drawDataLabels.call(o)}))}getValues(o,r){const e=r.period,i=o.xData,t=o.yData,n=t?t.length:0,l=this[r.algorithm+"Placement"],g=[],h=[],p=[];let c,s,a,u,d,y,D,f;if(!(i.length<e||!I(t[0])||t[0].length!==4)){for(f=e+1;f<=n+e;f+=e)a=i.slice(f-e-1,f),u=t.slice(f-e-1,f),s=a.length,c=a[s-1],y=this.getPivotAndHLC(u),D=l(y),d=g.push([c].concat(D)),h.push(c),p.push(g[d-1].slice(1));return this.endPoint=a[0]+(c-a[0])/s*e,{values:g,xData:h,yData:p}}}getPivotAndHLC(o){const r=o[o.length-1][3];let e=-1/0,i=1/0;return o.forEach(function(n){e=Math.max(e,n[1]),i=Math.min(i,n[2])}),[(e+i+r)/3,e,i,r]}standardPlacement(o){const r=o[1]-o[2];return[null,null,o[0]+r,o[0]*2-o[2],o[0],o[0]*2-o[1],o[0]-r,null,null]}camarillaPlacement(o){const r=o[1]-o[2];return[o[3]+r*1.5,o[3]+r*1.25,o[3]+r*1.1666,o[3]+r*1.0833,o[0],o[3]-r*1.0833,o[3]-r*1.1666,o[3]-r*1.25,o[3]-r*1.5]}fibonacciPlacement(o){const r=o[1]-o[2];return[null,o[0]+r,o[0]+r*.618,o[0]+r*.382,o[0],o[0]-r*.382,o[0]-r*.618,o[0]-r,null]}}return m.defaultOptions=M(T.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}}),L(m.prototype,{nameBase:"Pivot Points",pointArrayMap:["R4","R3","R2","R1","P","S1","S2","S3","S4"],pointValKey:"P",pointClass:A}),P.registerSeriesType("pivotpoints",m),m}),R(S,"Stock/Indicators/PPO/PPOIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{ema:v}=A.seriesTypes,{correctFloat:T,extend:M,merge:L,error:C}=P;class I extends v{getValues(x,o){const r=o.periods,e=o.index,i=[],t=[],n=[];let l,g;if(r.length!==2||r[1]<=r[0]){C('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');return}const h=super.getValues.call(this,x,{index:e,period:r[0]}),p=super.getValues.call(this,x,{index:e,period:r[1]});if(!h||!p)return;const c=r[1]-r[0];for(g=0;g<p.yData.length;g++)l=T((h.yData[g+c]-p.yData[g])/p.yData[g]*100),i.push([p.xData[g],l]),t.push(p.xData[g]),n.push(l);return{values:i,xData:t,yData:n}}}return I.defaultOptions=L(v.defaultOptions,{params:{period:void 0,periods:[12,26]}}),M(I.prototype,{nameBase:"PPO",nameComponents:["periods"]}),A.registerSeriesType("ppo",I),I}),R(S,"Stock/Indicators/ArrayUtilities.js",[],function(){function A(v,T,M){return v.reduce((L,C)=>[Math.min(L[0],C[T]),Math.max(L[1],C[M])],[Number.MAX_VALUE,-Number.MAX_VALUE])}return{getArrayExtremes:A}}),R(S,"Stock/Indicators/PC/PCIndicator.js",[S["Stock/Indicators/ArrayUtilities.js"],S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Color/Palettes.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v,T,M){const{sma:L}=T.seriesTypes,{merge:C,extend:I}=M;class m extends L{getValues(o,r){const e=r.period,i=o.xData,t=o.yData,n=t?t.length:0,l=[],g=2,h=1,p=[],c=[];let s,a,u,d,y,D,f;if(!(n<e)){for(f=e;f<=n;f++)d=i[f-1],y=t.slice(f-e,f),D=A.getArrayExtremes(y,g,h),a=D[1],u=D[0],s=(a+u)/2,l.push([d,a,s,u]),p.push(d),c.push([a,s,u]);return{values:l,xData:p,yData:c}}}}return m.defaultOptions=C(L.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:v.colors[2],lineWidth:1}},bottomLine:{styles:{lineColor:v.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}}),I(m.prototype,{areaLinesNames:["top","bottom"],nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),P.compose(m),T.registerSeriesType("pc",m),m}),R(S,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{extend:M,isArray:L,merge:C}=v;class I extends T{init(){super.init.apply(this,arguments),this.options=C({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)}getValues(x,o){const r=o.period,e=o.topBand,i=o.bottomBand,t=x.xData,n=x.yData,l=n?n.length:0,g=[],h=[],p=[];let c,s,a,u,d,y,D,f;if(!(t.length<r||!L(n[0])||n[0].length!==4)){for(f=r;f<=l;f++)d=t.slice(f-r,f),y=n.slice(f-r,f),D=super.getValues({xData:d,yData:y},o),u=D.xData[0],c=D.yData[0],s=c*(1+e),a=c*(1-i),g.push([u,s,c,a]),h.push(u),p.push([s,c,a]);return{values:g,xData:h,yData:p}}}}return I.defaultOptions=C(T.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}}),M(I.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"}),A.compose(I),P.registerSeriesType("priceenvelopes",I),I}),R(S,"Stock/Indicators/PSAR/PSARIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{merge:T}=P;function M(e,i){return parseFloat(e.toFixed(i))}function L(e,i,t,n){return e===1&&i>n||e===-1&&t>n?1:-1}function C(e,i,t,n,l,g,h,p){return e===i?e===1&&t>n||e===-1&&t<n?l===h?h:M(l+g,2):l:p}function I(e,i,t,n){return t===1?e>n?e:n:i<n?i:n}function m(e,i){return e-i}function x(e,i){return e*i}function o(e,i,t,n,l,g,h,p,c){return e===i?e===1?t+n<Math.min(l,g)?t+n:Math.min(l,g):t+n>Math.max(p,h)?t+n:Math.max(p,h):c}class r extends v{constructor(){super(...arguments),this.nameComponents=void 0}getValues(i,t){const n=i.xData,l=i.yData,g=t.maxAccelerationFactor,h=t.increment,p=t.initialAccelerationFactor,c=t.decimals,s=t.index,a=[],u=[],d=[];let y=t.initialAccelerationFactor,D,f=l[0][1],V,k,j,b=1,O,B,w,N,U=l[0][2],E,X,Y,F;if(!(s>=l.length)){for(F=0;F<s;F++)f=Math.max(l[F][1],f),U=Math.min(l[F][2],M(U,c));for(D=l[F][1]>U?1:-1,V=m(f,U),y=t.initialAccelerationFactor,k=x(y,V),a.push([n[s],U]),u.push(n[s]),d.push(M(U,c)),F=s+1;F<l.length;F++)O=l[F-1][2],B=l[F-2][2],w=l[F-1][1],N=l[F-2][1],X=l[F][1],Y=l[F][2],B!==null&&N!==null&&O!==null&&w!==null&&X!==null&&Y!==null&&(U=o(D,b,U,k,B,O,w,N,f),E=I(X,Y,D,f),j=L(b,Y,X,U),y=C(j,D,E,f,y,h,g,p),V=m(E,U),k=x(y,V),a.push([n[F],M(U,c)]),u.push(n[F]),d.push(M(U,c)),b=D,D=j,f=E);return{values:a,xData:u,yData:d}}}}return r.defaultOptions=T(v.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}}),A.registerSeriesType("psar",r),r}),R(S,"Stock/Indicators/ROC/ROCIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isArray:T,merge:M,extend:L}=P;function C(m,x,o,r,e){let i,t;return e<0?(i=x[o-r],t=i?(x[o]-i)/i*100:null):(i=x[o-r][e],t=i?(x[o][e]-i)/i*100:null),[m[o],t]}class I extends v{getValues(x,o){const r=o.period,e=x.xData,i=x.yData,t=i?i.length:0,n=[],l=[],g=[];let h,p=-1,c;if(!(e.length<=r)){for(T(i[0])&&(p=o.index),h=r;h<t;h++)c=C(e,i,h,r,p),n.push(c),l.push(c[0]),g.push(c[1]);return{values:n,xData:l,yData:g}}}}return I.defaultOptions=M(v.defaultOptions,{params:{index:3,period:9}}),L(I.prototype,{nameBase:"Rate of Change"}),A.registerSeriesType("roc",I),I}),R(S,"Stock/Indicators/RSI/RSIIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isNumber:T,merge:M}=P;function L(I,m){return parseFloat(I.toFixed(m))}class C extends v{getValues(m,x){const o=x.period,r=m.xData,e=m.yData,i=e?e.length:0,t=x.decimals,n=[],l=[],g=[];let h=0,p=0,c=x.index,s=1,a,u,d,y,D,f;if(!(r.length<o)){for(T(e[0])?f=e:(c=Math.min(c,e[0].length-1),f=e.map(V=>V[c]));s<o;)u=L(f[s]-f[s-1],t),u>0?h+=u:p+=Math.abs(u),s++;for(d=L(h/(o-1),t),y=L(p/(o-1),t),D=s;D<i;D++)u=L(f[D]-f[D-1],t),u>0?(h=u,p=0):(h=0,p=Math.abs(u)),d=L((d*(o-1)+h)/o,t),y=L((y*(o-1)+p)/o,t),y===0?a=100:d===0?a=0:a=L(100-100/(1+d/y),t),n.push([r[D],a]),l.push(r[D]),g.push(a);return{values:n,xData:l,yData:g}}}}return C.defaultOptions=M(v.defaultOptions,{params:{decimals:4,index:3}}),A.registerSeriesType("rsi",C),C}),R(S,"Stock/Indicators/Stochastic/StochasticIndicator.js",[S["Stock/Indicators/ArrayUtilities.js"],S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v,T){const{sma:M}=v.seriesTypes,{extend:L,isArray:C,merge:I}=T;class m extends M{init(){super.init.apply(this,arguments),this.options=I({smoothedLine:{styles:{lineColor:this.color}}},this.options)}getValues(o,r){const e=r.periods[0],i=r.periods[1],t=o.xData,n=o.yData,l=n?n.length:0,g=[],h=[],p=[],c=3,s=2,a=1;let u,d,y,D,f,V=null,k,j,b;if(l<e||!C(n[0])||n[0].length!==4)return;let O=!0,B=0;for(b=e-1;b<l;b++){if(u=n.slice(b-e+1,b+1),j=A.getArrayExtremes(u,s,a),D=j[0],d=n[b][c]-D,y=j[1]-D,f=d/y*100,isNaN(f)&&O){B++;continue}else O&&!isNaN(f)&&(O=!1);const w=h.push(t[b]);isNaN(f)?p.push([p[w-2]&&typeof p[w-2][0]=="number"?p[w-2][0]:null,null]):p.push([f,null]),b>=B+(e-1)+(i-1)&&(k=super.getValues({xData:h.slice(-i),yData:p.slice(-i)},{period:i}),V=k.yData[0]),g.push([t[b],f,V]),p[w-1][1]=V}return{values:g,xData:h,yData:p}}}return m.defaultOptions=I(M.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}}),L(m.prototype,{areaLinesNames:[],nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"]}),P.compose(m),v.registerSeriesType("stochastic",m),m}),R(S,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v,stochastic:T}=A.seriesTypes,{extend:M,merge:L}=P;class C extends T{getValues(m,x){const o=x.periods,r=super.getValues.call(this,m,x),e={values:[],xData:[],yData:[]};if(!r)return;e.xData=r.xData.slice(o[1]-1);const i=r.yData.slice(o[1]-1),t=v.prototype.getValues.call(this,{xData:e.xData,yData:i},{index:1,period:o[2]});if(t){for(let n=0,l=e.xData.length;n<l;n++)e.yData[n]=[i[n][1],t.yData[n-o[2]+1]||null],e.values[n]=[e.xData[n],i[n][1],t.yData[n-o[2]+1]||null];return e}}}return C.defaultOptions=L(T.defaultOptions,{params:{periods:[14,3,3]}}),M(C.prototype,{nameBase:"Slow Stochastic"}),A.registerSeriesType("slowstochastic",C),C}),R(S,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{atr:v,sma:T}=A.seriesTypes,{addEvent:M,correctFloat:L,isArray:C,extend:I,merge:m,objectEach:x}=P;function o(e,i,t){return{index:i,close:e.yData[i][t],x:e.xData[i]}}class r extends T{init(){const i=this;super.init.apply(i,arguments);const t=M(this.chart.constructor,"afterLinkSeries",()=>{if(i.options){const n=i.options,l=i.linkedParent.options;n.cropThreshold=l.cropThreshold-(n.params.period-1)}t()},{order:1})}drawGraph(){const i=this,t=i.options,n=i.linkedParent,l=n?n.points:[],g=i.points,h=i.graph,p=l.length-g.length,c=p>0?p:0,s={options:{gapSize:t.gapSize}},a={top:[],bottom:[],intersect:[]},u={top:{styles:{lineWidth:t.lineWidth,lineColor:t.fallingTrendColor||t.color,dashStyle:t.dashStyle}},bottom:{styles:{lineWidth:t.lineWidth,lineColor:t.risingTrendColor||t.color,dashStyle:t.dashStyle}},intersect:t.changeTrendLine},d=3;let y,D,f,V,k,j,b,O,B,w=g.length;for(;w--;)y=g[w],D=g[w-1],f=l[w-1+c],V=l[w-2+c],k=l[w+c],j=l[w+c+1],b=y.options.color,O={x:y.x,plotX:y.plotX,plotY:y.plotY,isNull:!1},!V&&f&&n.yData[f.index-1]&&(V=o(n,f.index-1,d)),!j&&k&&n.yData[k.index+1]&&(j=o(n,k.index+1,d)),!f&&V&&n.yData[V.index+1]?f=o(n,V.index+1,d):!f&&k&&n.yData[k.index-1]&&(f=o(n,k.index-1,d)),y&&f&&k&&V&&y.x!==f.x&&(y.x===k.x?(V=f,f=k):y.x===V.x?(f=V,V={close:n.yData[f.index-1][d],x:n.xData[f.index-1]}):j&&y.x===j.x&&(f=j,V=k)),D&&V&&f?(B={x:D.x,plotX:D.plotX,plotY:D.plotY,isNull:!1},y.y>=f.close&&D.y>=V.close?(y.color=b||t.fallingTrendColor||t.color,a.top.push(O)):y.y<f.close&&D.y<V.close?(y.color=b||t.risingTrendColor||t.color,a.bottom.push(O)):(a.intersect.push(O),a.intersect.push(B),a.intersect.push(m(B,{isNull:!0})),y.y>=f.close&&D.y<V.close?(y.color=b||t.fallingTrendColor||t.color,D.color=b||t.risingTrendColor||t.color,a.top.push(O),a.top.push(m(B,{isNull:!0}))):y.y<f.close&&D.y>=V.close&&(y.color=b||t.risingTrendColor||t.color,D.color=b||t.fallingTrendColor||t.color,a.bottom.push(O),a.bottom.push(m(B,{isNull:!0}))))):f&&(y.y>=f.close?(y.color=b||t.fallingTrendColor||t.color,a.top.push(O)):(y.color=b||t.risingTrendColor||t.color,a.bottom.push(O)));x(a,function(N,U){i.points=N,i.options=m(u[U].styles,s),i.graph=i["graph"+U+"Line"],T.prototype.drawGraph.call(i),i["graph"+U+"Line"]=i.graph}),i.points=g,i.options=t,i.graph=h}getValues(i,t){const n=t.period,l=t.multiplier,g=i.xData,h=i.yData,p=[],c=[],s=[],a=3,u=2,d=1,y=n===0?0:n-1,D=[],f=[];let V=[],k,j,b,O,B,w,N,U,E;if(!(g.length<=n||!C(h[0])||h[0].length!==4||n<0)){for(V=v.prototype.getValues.call(this,i,{period:n}).yData,E=0;E<V.length;E++)U=h[y+E],N=h[y+E-1]||[],O=D[E-1],B=f[E-1],w=s[E-1],E===0&&(O=B=w=0),k=L((U[d]+U[u])/2+l*V[E]),j=L((U[d]+U[u])/2-l*V[E]),k<O||N[a]>O?D[E]=k:D[E]=O,j>B||N[a]<B?f[E]=j:f[E]=B,w===O&&U[a]<D[E]||w===B&&U[a]<f[E]?b=D[E]:(w===O&&U[a]>D[E]||w===B&&U[a]>f[E])&&(b=f[E]),p.push([g[y+E],b]),c.push(g[y+E]),s.push(b);return{values:p,xData:c,yData:s}}}}return r.defaultOptions=m(T.defaultOptions,{params:{index:void 0,multiplier:3,period:10},risingTrendColor:"#06b535",fallingTrendColor:"#f21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}}),I(r.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"]}),A.registerSeriesType("supertrend",r),r}),R(S,"Stock/Indicators/VBP/VBPPoint.js",[S["Core/Series/SeriesRegistry.js"]],function(A){const{sma:{prototype:{pointClass:P}}}=A.seriesTypes;class v extends P{destroy(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy()),super.destroy.apply(this,arguments)}}return v}),R(S,"Stock/Indicators/VBP/VBPIndicator.js",[S["Stock/Indicators/VBP/VBPPoint.js"],S["Core/Animation/AnimationUtilities.js"],S["Core/Globals.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v,T,M){const{animObject:L}=P,{noop:C}=v,{column:{prototype:I},sma:m}=T.seriesTypes,{addEvent:x,arrayMax:o,arrayMin:r,correctFloat:e,defined:i,error:t,extend:n,isArray:l,merge:g}=M,h=Math.abs;function p(s){const a=s.length;let u=s[0][3],d=u,y=1,D;for(;y<a;y++)D=s[y][3],D<u&&(u=D),D>d&&(d=D);return{min:u,max:d}}class c extends m{init(a,u){const d=this;delete u.data,super.init.apply(d,arguments);const y=x(this.chart.constructor,"afterLinkSeries",function(){if(d.options){const D=d.options.params,f=d.linkedParent,V=a.get(D.volumeSeriesID);d.addCustomEvents(f,V)}y()},{order:1});return d}addCustomEvents(a,u){const d=this,y=()=>{d.chart.redraw(),d.setData([]),d.zoneStarts=[],d.zoneLinesSVG&&(d.zoneLinesSVG=d.zoneLinesSVG.destroy())};return d.dataEventsToUnbind.push(x(a,"remove",function(){y()})),u&&d.dataEventsToUnbind.push(x(u,"remove",function(){y()})),d}animate(a){const u=this,d=u.chart.inverted,y=u.group,D={};if(!a&&y){const f=d?u.yAxis.top:u.xAxis.left;d?(y["forceAnimate:translateY"]=!0,D.translateY=f):(y["forceAnimate:translateX"]=!0,D.translateX=f),y.animate(D,n(L(u.options.animation),{step:function(V,k){u.group.attr({scaleX:Math.max(.001,k.pos)})}}))}}drawPoints(){const a=this;a.options.volumeDivision.enabled&&(a.posNegVolume(!0,!0),I.drawPoints.apply(a,arguments),a.posNegVolume(!1,!1)),I.drawPoints.apply(a,arguments)}posNegVolume(a,u){const d=this,y=u?["positive","negative"]:["negative","positive"],D=d.options.volumeDivision,f=d.points.length;let V=[],k=[],j=0,b,O,B,w;for(a?(d.posWidths=V,d.negWidths=k):(V=d.posWidths,k=d.negWidths);j<f;j++)w=d.points[j],w[y[0]+"Graphic"]=w.graphic,w.graphic=w[y[1]+"Graphic"],a&&(b=w.shapeArgs.width,O=d.priceZones[j],B=O.wholeVolumeData,B?(V.push(b/B*O.positiveVolumeData),k.push(b/B*O.negativeVolumeData)):(V.push(0),k.push(0))),w.color=u?D.styles.positiveColor:D.styles.negativeColor,w.shapeArgs.width=u?d.posWidths[j]:d.negWidths[j],w.shapeArgs.x=u?w.shapeArgs.x:d.posWidths[j]}translate(){const a=this,u=a.options,d=a.chart,y=a.yAxis,D=y.min,f=a.options.zoneLines,V=a.priceZones;let k=0,j,b,O,B,w,N,U,E,X,Y,F;I.translate.apply(a);const _=a.points;_.length&&(E=u.pointPadding<.5?u.pointPadding:.1,j=a.volumeDataArray,b=o(j),O=d.plotWidth/2,X=d.plotTop,B=h(y.toPixels(D)-y.toPixels(D+a.rangeStep)),N=h(y.toPixels(D)-y.toPixels(D+a.rangeStep)),E&&(w=h(B*(1-2*E)),k=h((B-w)/2),B=h(w)),_.forEach(function(z,G){Y=z.barX=z.plotX=0,F=z.plotY=y.toPixels(V[G].start)-X-(y.reversed?B-N:B)-k,U=e(O*V[G].wholeVolumeData/b),z.pointWidth=U,z.shapeArgs=a.crispCol.apply(a,[Y,F,U,B]),z.volumeNeg=V[G].negativeVolumeData,z.volumePos=V[G].positiveVolumeData,z.volumeAll=V[G].wholeVolumeData}),f.enabled&&a.drawZones(d,y,a.zoneStarts,f.styles))}getExtremes(){const a=this.options.compare,u=this.options.cumulative;let d;return this.options.compare?(this.options.compare=void 0,d=super.getExtremes(),this.options.compare=a):this.options.cumulative?(this.options.cumulative=!1,d=super.getExtremes(),this.options.cumulative=u):d=super.getExtremes(),d}getValues(a,u){const d=this,y=a.processedXData,D=a.processedYData,f=d.chart,V=u.ranges,k=[],j=[],b=[],O=f.get(u.volumeSeriesID);if(!a.chart){t("Base series not found! In case it has been removed, add a new one.",!0,f);return}if(!O||!O.processedXData.length){const N=O&&!O.processedXData.length?" does not contain any data.":" not found! Check `volumeSeriesID`.";t("Series "+u.volumeSeriesID+N,!0,f);return}const B=l(D[0]);if(B&&D[0].length!==4){t("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,f);return}return(d.priceZones=d.specifyZones(B,y,D,V,O)).forEach(function(N,U){k.push([N.x,N.end]),j.push(k[U][0]),b.push(k[U][1])}),{values:k,xData:j,yData:b}}specifyZones(a,u,d,y,D){const f=this,V=a?p(d):!1,k=f.zoneStarts=[],j=[];let b=V?V.min:r(d),O=V?V.max:o(d),B=0,w=1;const N=f.linkedParent;if(!f.options.compareToMain&&N.dataModify&&(b=N.dataModify.modifyValue(b),O=N.dataModify.modifyValue(O)),!i(b)||!i(O))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];const U=f.rangeStep=e(O-b)/y;for(k.push(b);B<y-1;B++)k.push(e(k[B]+U));k.push(O);const E=k.length;for(;w<E;w++)j.push({index:w-1,x:u[0],start:k[w-1],end:k[w]});return f.volumePerZone(a,j,D,u,d)}volumePerZone(a,u,d,y,D){const f=this,V=d.processedXData,k=d.processedYData,j=u.length-1,b=D.length,O=k.length;let B,w,N,U,E;return h(b-O)&&(y[0]!==V[0]&&k.unshift(0),y[b-1]!==V[O-1]&&k.push(0)),f.volumeDataArray=[],u.forEach(function(X){for(X.wholeVolumeData=0,X.positiveVolumeData=0,X.negativeVolumeData=0,E=0;E<b;E++){w=!1,N=!1,U=a?D[E][3]:D[E],B=E?a?D[E-1][3]:D[E-1]:U;const Y=f.linkedParent;!f.options.compareToMain&&Y.dataModify&&(U=Y.dataModify.modifyValue(U),B=Y.dataModify.modifyValue(B)),U<=X.start&&X.index===0&&(w=!0),U>=X.end&&X.index===j&&(N=!0),(U>X.start||w)&&(U<X.end||N)&&(X.wholeVolumeData+=k[E],B>U?X.negativeVolumeData+=k[E]:X.positiveVolumeData+=k[E])}f.volumeDataArray.push(X.wholeVolumeData)}),u}drawZones(a,u,d,y){const D=this,f=a.renderer,V=0,k=a.plotWidth,j=a.plotTop;let b=D.zoneLinesSVG,O=[],B;d.forEach(function(w){B=u.toPixels(w)-j,O=O.concat(a.renderer.crispLine([["M",V,B],["L",k,B]],y.lineWidth))}),b?b.animate({d:O}):b=D.zoneLinesSVG=f.path(O).attr({"stroke-width":y.lineWidth,stroke:y.color,dashstyle:y.dashStyle,zIndex:D.group.zIndex+.1}).add(D.group)}}return c.defaultOptions=g(m.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1e3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"0.5em"},verticalAlign:"top"}}),n(c.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:A,markerAttribs:C,drawGraph:C,getColumnMetrics:I.getColumnMetrics,crispCol:I.crispCol}),T.registerSeriesType("vbp",c),c}),R(S,"Stock/Indicators/VWAP/VWAPIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{error:T,isArray:M,merge:L}=P;class C extends v{getValues(m,x){const o=this,r=m.chart,e=m.xData,i=m.yData,t=x.period;let n=!0,l;if(!(l=r.get(x.volumeSeriesID))){T("Series "+x.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,r);return}return M(i[0])||(n=!1),o.calculateVWAPValues(n,e,i,l,t)}calculateVWAPValues(m,x,o,r,e){const i=r.yData,t=r.xData.length,n=x.length,l=[],g=[],h=[],p=[],c=[];let s,a,u,d,y,D;for(n<=t?s=n:s=t,y=0,D=0;y<s;y++)a=m?(o[y][1]+o[y][2]+o[y][3])/3:o[y],a*=i[y],u=D?l[y-1]+a:a,d=D?g[y-1]+i[y]:i[y],l.push(u),g.push(d),c.push([x[y],u/d]),h.push(c[y][0]),p.push(c[y][1]),D++,D===e&&(D=0);return{values:c,xData:h,yData:p}}}return C.defaultOptions=L(v.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}}),A.registerSeriesType("vwap",C),C}),R(S,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[S["Stock/Indicators/ArrayUtilities.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{extend:M,isArray:L,merge:C}=v;class I extends T{getValues(x,o){const r=o.period,e=x.xData,i=x.yData,t=i?i.length:0,n=[],l=[],g=[],h=3,p=2,c=1;let s,a,u,d,y,D,f;if(!(e.length<r||!L(i[0])||i[0].length!==4)){for(f=r-1;f<t;f++)s=i.slice(f-r+1,f+1),a=A.getArrayExtremes(s,p,c),y=a[0],d=a[1],D=i[f][h],u=(d-D)/(d-y)*-100,e[f]&&(n.push([e[f],u]),l.push(e[f]),g.push(u));return{values:n,xData:l,yData:g}}}}return I.defaultOptions=C(T.defaultOptions,{params:{index:void 0,period:14}}),M(I.prototype,{nameBase:"Williams %R"}),P.registerSeriesType("williamsr",I),I}),R(S,"Stock/Indicators/WMA/WMAIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isArray:T,merge:M}=P;function L(x,o,r,e,i){const t=o[e],n=i<0?r[e]:r[e][i];x.push([t,n])}function C(x,o){const r=(o+1)/2*o;return x.reduce(function(e,i,t){return[null,e[1]+i[1]*(t+1)]})[1]/r}function I(x,o,r,e){const i=x.length,t=C(x,i),n=o[e-1];return x.shift(),[n,t]}class m extends v{getValues(o,r){const e=r.period,i=o.xData,t=o.yData,n=t?t.length:0,l=i[0],g=[],h=[],p=[];let c=1,s=-1,a,u,d=t[0];if(i.length<e)return;T(t[0])&&(s=r.index,d=t[0][s]);const y=[[l,d]];for(;c!==e;)L(y,i,t,c,s),c++;for(a=c;a<n;a++)u=I(y,i,t,a),g.push(u),h.push(u[0]),p.push(u[1]),L(y,i,t,a,s);return u=I(y,i,t,a),g.push(u),h.push(u[0]),p.push(u[1]),{values:g,xData:h,yData:p}}}return m.defaultOptions=M(v.defaultOptions,{params:{index:3,period:9}}),A.registerSeriesType("wma",m),m}),R(S,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{merge:T,extend:M}=P;class L extends v{getValues(I,m){const x=m.lowIndex,o=m.highIndex,r=m.deviation/100,e={low:1+r,high:1-r},i=I.xData,t=I.yData,n=t?t.length:0,l=[],g=[],h=[];let p,c,s,a,u=!1,d=!1;if(!i||i.length<=1||n&&(typeof t[0][x]>"u"||typeof t[0][o]>"u"))return;const y=t[0][x],D=t[0][o];for(p=1;p<n;p++)t[p][x]<=D*e.high?(l.push([i[0],D]),s=[i[p],t[p][x]],a=!0,u=!0):t[p][o]>=y*e.low&&(l.push([i[0],y]),s=[i[p],t[p][o]],a=!1,u=!0),u&&(g.push(l[0][0]),h.push(l[0][1]),c=p++,p=n);for(p=c;p<n;p++)a?(t[p][x]<=s[1]&&(s=[i[p],t[p][x]]),t[p][o]>=s[1]*e.low&&(d=o)):(t[p][o]>=s[1]&&(s=[i[p],t[p][o]]),t[p][x]<=s[1]*e.high&&(d=x)),d!==!1&&(l.push(s),g.push(s[0]),h.push(s[1]),s=[i[p],t[p][d]],a=!a,d=!1);const f=l.length;return f!==0&&l[f-1][0]<i[n-1]&&(l.push(s),g.push(s[0]),h.push(s[1])),{values:l,xData:g,yData:h}}}return L.defaultOptions=T(v.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}}),M(L.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag"}),A.registerSeriesType("zigzag",L),L}),R(S,"Stock/Indicators/LinearRegression/LinearRegressionIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{isArray:T,extend:M,merge:L}=P;class C extends v{getRegressionLineParameters(m,x){const o=this.options.params.index,r=function(a,u){return T(a)?a[u]:a},e=m.reduce(function(a,u){return u+a},0),i=x.reduce(function(a,u){return r(u,o)+a},0),t=e/m.length,n=i/x.length;let l,g,h,p=0,c=0;for(h=0;h<m.length;h++)l=m[h]-t,g=r(x[h],o)-n,p+=l*g,c+=Math.pow(l,2);const s=c?p/c:0;return{slope:s,intercept:n-s*t}}getEndPointY(m,x){return m.slope*x+m.intercept}transformXData(m,x){const o=m[0];return m.map(function(r){return(r-o)/x})}findClosestDistance(m){let x,o,r;for(r=1;r<m.length-1;r++)x=m[r]-m[r-1],x>0&&(typeof o>"u"||x<o)&&(o=x);return o}getValues(m,x){const o=m.xData,r=m.yData,e=x.period,i={xData:[],yData:[],values:[]},t=this.options.params.xAxisUnit||this.findClosestDistance(o);let n,l,g,h,p,c,s,a,u;for(l=e-1;l<=o.length-1;l++)g=l-e+1,h=l+1,p=o[l],s=o.slice(g,h),a=r.slice(g,h),u=this.transformXData(s,t),n=this.getRegressionLineParameters(u,a),c=this.getEndPointY(n,u[u.length-1]),i.values.push({regressionLineParameters:n,x:p,y:c}),i.xData.push(p),i.yData.push(c);return i}}return C.defaultOptions=L(v.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}}),M(C.prototype,{nameBase:"Linear Regression Indicator"}),A.registerSeriesType("linearRegression",C),C}),R(S,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopesIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{linearRegression:v}=A.seriesTypes,{extend:T,merge:M}=P;class L extends v{getEndPointY(I){return I.slope}}return L.defaultOptions=M(v.defaultOptions),T(L.prototype,{nameBase:"Linear Regression Slope Indicator"}),A.registerSeriesType("linearRegressionSlope",L),L}),R(S,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionInterceptIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{linearRegression:v}=A.seriesTypes,{extend:T,merge:M}=P;class L extends v{getEndPointY(I){return I.intercept}}return L.defaultOptions=M(v.defaultOptions),T(L.prototype,{nameBase:"Linear Regression Intercept Indicator"}),A.registerSeriesType("linearRegressionIntercept",L),L}),R(S,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngleIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{linearRegression:v}=A.seriesTypes,{extend:T,merge:M}=P;class L extends v{slopeToAngle(I){return Math.atan(I)*(180/Math.PI)}getEndPointY(I){return this.slopeToAngle(I.slope)}}return L.defaultOptions=M(v.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">●</span>{series.name}: <b>{point.y}°</b><br/>'}}),T(L.prototype,{nameBase:"Linear Regression Angle Indicator"}),A.registerSeriesType("linearRegressionAngle",L),L}),R(S,"Stock/Indicators/ABands/ABandsIndicator.js",[S["Stock/Indicators/MultipleLinesComposition.js"],S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P,v){const{sma:T}=P.seriesTypes,{correctFloat:M,extend:L,merge:C}=v;function I(r,e,i){return M(e-r)/(M(e+r)/2)*1e3*i}function m(r,e){return r*M(1+2*e)}function x(r,e){return r*M(1-2*e)}class o extends T{getValues(e,i){const t=i.period,n=i.factor,l=i.index,g=e.xData,h=e.yData,p=h?h.length:0,c=[],s=[],a=[],u=2,d=1,y=[],D=[];let f,V,k,j,b,O,B,w,N,U,E;if(!(p<t)){for(E=0;E<=p;E++)E<p&&(b=I(h[E][u],h[E][d],n),c.push(m(h[E][d],b)),s.push(x(h[E][u],b))),E>=t&&(N=g.slice(E-t,E),U=h.slice(E-t,E),B=super.getValues.call(this,{xData:N,yData:c.slice(E-t,E)},{period:t}),w=super.getValues.call(this,{xData:N,yData:s.slice(E-t,E)},{period:t}),O=super.getValues.call(this,{xData:N,yData:U},{period:t,index:l}),j=O.xData[0],V=B.yData[0],k=w.yData[0],f=O.yData[0],a.push([j,V,f,k]),y.push(j),D.push([V,f,k]));return{values:a,xData:y,yData:D}}}}return o.defaultOptions=C(T.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}}),L(o.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"}),A.compose(o),P.registerSeriesType("abands",o),o}),R(S,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{extend:T,merge:M,isArray:L}=P;class C extends v{constructor(){super(...arguments),this.updateAllPoints=!0}getValues(m,x){const o=m.xData,r=m.yData,e=[],i=[],t=[],n=[],l=x.index;let g=0,h=0,p=0,c=0,s=0;for(let d=0;d<o.length;d++)(d===0||o[d]!==o[d-1])&&s++,e.push(s);for(let d=0;d<e.length;d++)p+=e[d],c+=L(r[d])?r[d][l]:r[d];const a=p/e.length,u=c/r.length;for(let d=0;d<e.length;d++){const y=L(r[d])?r[d][l]:r[d];g+=(e[d]-a)*(y-u),h+=Math.pow(e[d]-a,2)}for(let d=0;d<e.length;d++){if(o[d]===t[t.length-1])continue;const y=o[d],D=u+g/h*(e[d]-a);i.push([y,D]),t.push(y),n.push(D)}return{xData:t,yData:n,values:i}}}return C.defaultOptions=M(v.defaultOptions,{params:{period:void 0,index:3}}),T(C.prototype,{nameBase:"Trendline",nameComponents:void 0}),A.registerSeriesType("trendline",C),C}),R(S,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",[S["Core/Series/SeriesRegistry.js"],S["Core/Utilities.js"]],function(A,P){const{sma:v}=A.seriesTypes,{correctFloat:T,defined:M,extend:L,isArray:C,merge:I}=P;class m extends v{init(){const o=arguments,r=this,e=o[1].params,i=e&&e.average?e.average:void 0;r.averageIndicator=A.seriesTypes[i]||v,r.averageIndicator.prototype.init.apply(r,o)}calculateDisparityIndex(o,r){return T(o-r)/r*100}getValues(o,r){const e=r.index,i=o.xData,t=o.yData,n=t?t.length:0,l=[],g=[],h=[],p=this.averageIndicator,c=C(t[0]),s=p.prototype.getValues(o,r),a=s.yData,u=i.indexOf(s.xData[0]);if(!(!a||a.length===0||!M(e)||t.length<=u)){for(let d=u;d<n;d++){const y=this.calculateDisparityIndex(c?t[d][e]:t[d],a[d-u]);l.push([i[d],y]),g.push(i[d]),h.push(y)}return{values:l,xData:g,yData:h}}}}return m.defaultOptions=I(v.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},dataGrouping:{approximation:"averages"}}),L(m.prototype,{nameBase:"Disparity Index",nameComponents:["period","average"]}),A.registerSeriesType("disparityindex",m),m}),R(S,"masters/indicators/indicators-all.src.js",[S["Core/Globals.js"]],function(A){return A})})}(oe)),oe.exports}var le=re();const pe=ae(le),ue=Object.freeze(Object.defineProperty({__proto__:null,default:pe},Symbol.toStringTag,{value:"Module"}));export{ue as i};
