import { defineComponent, ref, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "view",
  __ssrInlineRender: true,
  props: {
    setting: {}
  },
  setup(__props) {
    const activeQuestionKey = ref(null);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.setting.questions.length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "index-space" }, _attrs))}><div class="flex items-center flex-col text-xl">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fa", "circle-question"],
          class: "text-red-500"
        }, null, _parent));
        _push(`<h1 class="py-3">${ssrInterpolate(_ctx.setting.title ?? "سوالات متداول")}</h1></div><div class="questions"><!--[-->`);
        ssrRenderList(_ctx.setting.questions, (question, key) => {
          _push(`<div><div class="${ssrRenderClass([{ "border-b": key != _ctx.setting.questions.length - 1 }, "flex justify-between items-center cursor-pointer py-5"])}"><h1>${ssrInterpolate(question.title)}</h1>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", unref(activeQuestionKey) == key ? "angle-up" : "angle-down"],
            class: "text-red-500"
          }, null, _parent));
          _push(`</div>`);
          if (unref(activeQuestionKey) == key) {
            _push(`<div class="py-3 text-gray-700 leading-8">${question.answer ?? ""}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/faq/widget/view.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=view-BT3-zKlv.js.map
