import { _ as _sfc_main$1 } from "./PositionView-ByKT-amv.js";
import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent } from "vue/server-renderer";
import { u as useState, b as useRuntimeConfig } from "../server.mjs";
import { u as useHead } from "./v3-CqizLg04.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
import "D:/Work/Ahmadi/shop/frontend/node_modules/@unhead/vue/dist/index.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const shopSetting = useState("shopSetting");
    const { appUrl, serverUrl } = useRuntimeConfig().public;
    useHead({
      title: "فروشگاه اینترنتی " + shopSetting.value.name,
      meta: [
        {
          name: "description",
          content: shopSetting.value.description
        },
        {
          name: "keywords",
          content: shopSetting.value.tags
        }
      ],
      script: [
        {
          type: "application/ld+json",
          children: JSON.stringify({
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": shopSetting.value.name,
            "url": appUrl,
            "logo": serverUrl + "/" + shopSetting.value.icon,
            "contactPoint": {
              "@type": "ContactPoint",
              "telephone": "+989141592083",
              "contactType": "customer service",
              "areaServed": "IR",
              "availableLanguage": "فارسی"
            }
          })
        }
      ]
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_DesignPositionView = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_DesignPositionView, { position: "desktop-index" }, null, _parent));
      } else {
        _push(ssrRenderComponent(_component_DesignPositionView, { position: "mobile-index" }, null, _parent));
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=index-DLFsVDyN.js.map
