import { _ as _sfc_main$b } from "./Layout-tZUvOK2Y.js";
import { _ as _sfc_main$c } from "./Box-P2bb9SjA.js";
import { _ as _sfc_main$d } from "./Tabs-CzUlKuXU.js";
import { defineComponent, mergeProps, withCtx, unref, createVNode, useSSRContext, resolveComponent, createBlock, createCommentVNode, openBlock, toDisplayString, ref, isRef } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderClass } from "vue/server-renderer";
import { b as useRuntimeConfig, g as __nuxt_component_0, c as useNuxtApp, h as _sfc_main$9, u as useState } from "../server.mjs";
import { _ as _sfc_main$a } from "./EmptyList-DlpsHik2.js";
import _sfc_main$8 from "./FactorLink-DOFSg108.js";
import { u as useMonthsList } from "./MonthsList-B1ySoCWX.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "OrderProducts",
  __ssrInlineRender: true,
  props: {
    order: {}
  },
  setup(__props) {
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      if (_ctx.order && _ctx.order.submissions) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-5 flex flex-wrap" }, _attrs))}><!--[-->`);
        ssrRenderList(_ctx.order.submissions, (submission) => {
          _push(`<!--[--><!--[-->`);
          ssrRenderList(submission.items, (item) => {
            _push(ssrRenderComponent(_component_nuxt_link, {
              key: item.id,
              to: _ctx.$getProductPath(item.product)
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<img${ssrRenderAttr("src", unref(serverUrl) + "/thumbnails/" + item.product.image)} class="w-16 h-16 md:w-20 md:h-20 m-3" alt=""${_scopeId}>`);
                } else {
                  return [
                    createVNode("img", {
                      src: unref(serverUrl) + "/thumbnails/" + item.product.image,
                      class: "w-16 h-16 md:w-20 md:h-20 m-3",
                      alt: ""
                    }, null, 8, ["src"])
                  ];
                }
              }),
              _: 2
            }, _parent));
          });
          _push(`<!--]--><!--]-->`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<div${ssrRenderAttrs(_attrs)}><!--[-->`);
        ssrRenderList(_ctx.order.items, (item) => {
          _push(ssrRenderComponent(_component_nuxt_link, {
            key: item.id,
            to: _ctx.$getProductPath(item.product)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", unref(serverUrl) + "/thumbnails/" + item.product.image)} class="w-16 h-16 md:w-20 md:h-20 m-3" alt=""${_scopeId}>`);
              } else {
                return [
                  createVNode("img", {
                    src: unref(serverUrl) + "/thumbnails/" + item.product.image,
                    class: "w-16 h-16 md:w-20 md:h-20 m-3",
                    alt: ""
                  }, null, 8, ["src"])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div>`);
      }
    };
  }
});
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/OrderProducts.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "OrdersList",
  __ssrInlineRender: true,
  props: {
    orders: {}
  },
  setup(__props) {
    const months = useMonthsList();
    const global = useNuxtApp().vueApp.config.globalProperties;
    const orderStatutes = global["$order:statutes"];
    const getOrderDate = function(createdAt) {
      const date = global.$getDate(createdAt);
      let result = "";
      const ex = date.toString().split("/");
      if (ex.length == 3 && months[parseInt(ex[1])]) {
        result = `${ex[2]} ${months[parseInt(ex[1])]} ${ex[0]}`;
      }
      return result;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_OrdersUserOrderProducts = _sfc_main$7;
      const _component_OrdersUserFactorLink = _sfc_main$8;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "user-orders" }, _attrs))}><!--[-->`);
      ssrRenderList(_ctx.orders.data, (order) => {
        _push(`<div class="border rounded-md p-4 my-4">`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          class: "flex justify-between items-center",
          to: "/profile/orders/" + order.id
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(orderStatutes)[order.status]) {
                _push2(`<div class="py-3 flex items-center"${_scopeId}>`);
                if (unref(orderStatutes)[order.status].icon) {
                  _push2(ssrRenderComponent(_component_fa_icon, {
                    icon: unref(orderStatutes)[order.status].icon,
                    class: ["status text-xl", unref(orderStatutes)[order.status].key]
                  }, null, _parent2, _scopeId));
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<span class="font-bold px-3"${_scopeId}>${ssrInterpolate(unref(orderStatutes)[order.status].title)}</span></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "angle-left"] }, null, _parent2, _scopeId));
            } else {
              return [
                unref(orderStatutes)[order.status] ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "py-3 flex items-center"
                }, [
                  unref(orderStatutes)[order.status].icon ? (openBlock(), createBlock(_component_fa_icon, {
                    key: 0,
                    icon: unref(orderStatutes)[order.status].icon,
                    class: ["status text-xl", unref(orderStatutes)[order.status].key]
                  }, null, 8, ["icon", "class"])) : createCommentVNode("", true),
                  createVNode("span", { class: "font-bold px-3" }, toDisplayString(unref(orderStatutes)[order.status].title), 1)
                ])) : createCommentVNode("", true),
                createVNode(_component_fa_icon, { icon: ["fas", "angle-left"] })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<div class="py-2 text-sm max-lg:grid grid-cols-1 sm:grid-cols-2 lg:flex text-gray-400"><span class="max-lg:py-2">${ssrInterpolate(_ctx.$replaceEnNumber(getOrderDate(order.created_at)))}</span><div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">کد سفارش</span><span class="text-black font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(order.order_id))}</span></div><div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">مبلغ</span><span class="text-black font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(order.final_price)))} تومان </span></div>`);
        if (order.final_price != order.total_price) {
          _push(`<div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">تخفیف</span><span class="text-black font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(order.total_price - order.final_price + order.tax)))} تومان </span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(_component_OrdersUserOrderProducts, {
          order,
          class: "border-t"
        }, null, _parent));
        if (order.status >= 5) {
          _push(`<div class="border-t pt-3 flex justify-end">`);
          _push(ssrRenderComponent(_component_OrdersUserFactorLink, { order }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/OrdersList.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "CurrentOrders",
  __ssrInlineRender: true,
  setup(__props) {
    const orders = ref({ data: [] });
    const loading = ref(true);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$9;
      const _component_UsersPanelEmptyList = _sfc_main$a;
      const _component_OrdersUserOrdersList = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(loading)) {
        _push(`<div class="w-full flex justify-center py-10">`);
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div>`);
        if (unref(orders).data.length == 0) {
          _push(ssrRenderComponent(_component_UsersPanelEmptyList, { description: "سفارشی یافت نشد" }, null, _parent));
        } else {
          _push(ssrRenderComponent(_component_OrdersUserOrdersList, { orders: unref(orders) }, null, _parent));
        }
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/CurrentOrders.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "SentOrders",
  __ssrInlineRender: true,
  setup(__props) {
    const orders = ref({ data: [] });
    const loading = ref(true);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$9;
      const _component_OrdersUserOrdersList = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(loading)) {
        _push(`<div class="w-full flex justify-center py-10">`);
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div>`);
        if (unref(orders).data.length == 0) {
          _push(`<div class="empty-order"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/empty-list.svg")} alt="order-empty.svg"><span>سفارشی یافت نشد</span></div>`);
        } else {
          _push(`<div>`);
          _push(ssrRenderComponent(_component_OrdersUserOrdersList, { orders: unref(orders) }, null, _parent));
          _push(`</div>`);
        }
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/SentOrders.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "ReturnProducts",
  __ssrInlineRender: true,
  props: {
    list: {}
  },
  setup(__props) {
    const theme = useState("theme");
    const global = useNuxtApp().vueApp.config.globalProperties;
    const getRequestDate = function(createdAt) {
      return global.$getDate(createdAt);
    };
    const statusList = {
      "approved": {
        title: "تایید شده",
        icon: ["fas", "circle-check"],
        className: "text-green-500"
      },
      "awaiting-review": {
        title: "در انتظار دریافت",
        icon: ["fas", "clock-rotate-left"],
        className: "text-amber-600"
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_nuxt_link = __nuxt_component_0;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "user-orders" }, _attrs))}><!--[-->`);
      ssrRenderList(_ctx.list.data, (item) => {
        _push(`<div class="border rounded-md p-4 my-4"><div class="flex justify-between items-center"><div class="py-2 text-sm max-lg:grid grid-cols-2 lg:flex text-gray-400"><span class="max-lg:py-2">${ssrInterpolate(_ctx.$replaceEnNumber(getRequestDate(item.created_at)))}</span>`);
        if (unref(theme) == "desktop") {
          _push(`<!--[--><div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">کد پیگیری مرجوعی</span><span class="text-black">${ssrInterpolate(_ctx.$replaceEnNumber(item.tracking_code))}</span></div><div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">مبلغ</span><span class="text-black">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(item.price)))} تومان </span></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "angle-left"] }, null, _parent));
        _push(`</div>`);
        if (unref(theme) != "desktop") {
          _push(`<div><div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">کد پیگیری مرجوعی</span><span class="text-black">${ssrInterpolate(_ctx.$replaceEnNumber(item.tracking_code))}</span></div><div class="max-lg:py-2 lg:px-3 flex items-center"><div class="point"></div><span class="px-2">مبلغ</span><span class="text-black">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(item.price)))} تومان </span></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="grid gap-2 grid-cols-1 md:grid-cols-2"><!--[-->`);
        ssrRenderList(item.products, (product, key) => {
          _push(ssrRenderComponent(_component_nuxt_link, {
            to: _ctx.$getProductPath(product),
            class: "border rounded-md my-4 px-3 py-5",
            key
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (statusList[product.status]) {
                  _push2(`<div class="${ssrRenderClass([statusList[product.status].className, "flex items-center pb-3"])}"${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_fa_icon, {
                    icon: statusList[product.status].icon
                  }, null, _parent2, _scopeId));
                  _push2(`<span class="px-2 text-sm"${_scopeId}>${ssrInterpolate(statusList[product.status].title)}</span></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<div class="flex"${_scopeId}><div class="relative"${_scopeId}><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.staticServerUrl + "/images/" + product.image)}${ssrRenderAttr("alt", product.title)} class="w-20"${_scopeId}><span class="absolute bottom-0 left-0 bg-white px-2 rounded-tr-lg"${_scopeId}>${ssrInterpolate(_ctx.$replaceEnNumber(1))}</span></div><div class="px-2"${_scopeId}><h1 class="text-black font-bold text-sm"${_scopeId}>${ssrInterpolate(product.title)}</h1><div class="flex py-3 items-center"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_fa_icon, {
                  icon: ["fas", "circle-info"],
                  class: "text-gray-500"
                }, null, _parent2, _scopeId));
                _push2(`<p class="px-2 text-sm"${_scopeId}>${ssrInterpolate(product.description)}</p></div></div></div>`);
              } else {
                return [
                  statusList[product.status] ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: ["flex items-center pb-3", statusList[product.status].className]
                  }, [
                    createVNode(_component_fa_icon, {
                      icon: statusList[product.status].icon
                    }, null, 8, ["icon"]),
                    createVNode("span", { class: "px-2 text-sm" }, toDisplayString(statusList[product.status].title), 1)
                  ], 2)) : createCommentVNode("", true),
                  createVNode("div", { class: "flex" }, [
                    createVNode("div", { class: "relative" }, [
                      createVNode("img", {
                        src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.staticServerUrl + "/images/" + product.image,
                        alt: product.title,
                        class: "w-20"
                      }, null, 8, ["src", "alt"]),
                      createVNode("span", { class: "absolute bottom-0 left-0 bg-white px-2 rounded-tr-lg" }, toDisplayString(_ctx.$replaceEnNumber(1)), 1)
                    ]),
                    createVNode("div", { class: "px-2" }, [
                      createVNode("h1", { class: "text-black font-bold text-sm" }, toDisplayString(product.title), 1),
                      createVNode("div", { class: "flex py-3 items-center" }, [
                        createVNode(_component_fa_icon, {
                          icon: ["fas", "circle-info"],
                          class: "text-gray-500"
                        }),
                        createVNode("p", { class: "px-2 text-sm" }, toDisplayString(product.description), 1)
                      ])
                    ])
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div></div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/ReturnProducts.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "ReturnedOrders",
  __ssrInlineRender: true,
  setup(__props) {
    const list = ref({ data: [] });
    const loading = ref(true);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$9;
      const _component_OrdersUserReturnProducts = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(loading)) {
        _push(`<div class="w-full flex justify-center py-10">`);
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div>`);
        if (unref(list).data.length == 0) {
          _push(`<div class="empty-order"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/order-empty.svg")} alt="order-empty.svg"><span>کالایی یافت نشد</span></div>`);
        } else {
          _push(`<div>`);
          _push(ssrRenderComponent(_component_OrdersUserReturnProducts, { list: unref(list) }, null, _parent));
          _push(`</div>`);
        }
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/ReturnedOrders.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "CancelledOrders",
  __ssrInlineRender: true,
  setup(__props) {
    const orders = ref({ data: [] });
    const loading = ref(true);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$9;
      const _component_OrdersUserOrdersList = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(loading)) {
        _push(`<div class="w-full flex justify-center py-10">`);
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div>`);
        if (unref(orders).data.length == 0) {
          _push(ssrRenderComponent(_sfc_main$a, { description: "سفارشی یافت نشد" }, null, _parent));
        } else {
          _push(`<div>`);
          _push(ssrRenderComponent(_component_OrdersUserOrdersList, { orders: unref(orders) }, null, _parent));
          _push(`</div>`);
        }
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/CancelledOrders.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const activeTab = ref(0);
    const tabTitles = ref([
      { title: "جاری", count: 0, name: "current" },
      { title: "تحویل شده", count: 0, name: "sent" },
      { title: "مرجوع شده", count: 0, name: "returned" },
      { title: "لغو شده", count: 0, name: "cancelled" }
    ]);
    const tabContents = ref([
      { title: "جاری", component: _sfc_main$5 },
      { title: "تحویل شده", component: _sfc_main$4 },
      { title: "مرجوع شده", component: _sfc_main$2 },
      { title: "لغو شده", component: _sfc_main$1 }
    ]);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_UsersLayout = _sfc_main$b;
      const _component_UsersPanelBox = _sfc_main$c;
      const _component_Tabs = _sfc_main$d;
      _push(ssrRenderComponent(_component_UsersLayout, _attrs, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_UsersPanelBox, {
              title: unref(theme) == "desktop" ? "تاریخچه سفارشات" : void 0,
              class: "orders"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_Tabs, {
                    "hide-contents": "",
                    items: unref(tabTitles),
                    modelValue: unref(activeTab),
                    "onUpdate:modelValue": ($event) => isRef(activeTab) ? activeTab.value = $event : null
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_Tabs, {
                    "hide-tabs": "",
                    items: unref(tabContents),
                    modelValue: unref(activeTab),
                    "onUpdate:modelValue": ($event) => isRef(activeTab) ? activeTab.value = $event : null
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_Tabs, {
                      "hide-contents": "",
                      items: unref(tabTitles),
                      modelValue: unref(activeTab),
                      "onUpdate:modelValue": ($event) => isRef(activeTab) ? activeTab.value = $event : null
                    }, null, 8, ["items", "modelValue", "onUpdate:modelValue"]),
                    createVNode(_component_Tabs, {
                      "hide-tabs": "",
                      items: unref(tabContents),
                      modelValue: unref(activeTab),
                      "onUpdate:modelValue": ($event) => isRef(activeTab) ? activeTab.value = $event : null
                    }, null, 8, ["items", "modelValue", "onUpdate:modelValue"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_UsersPanelBox, {
                title: unref(theme) == "desktop" ? "تاریخچه سفارشات" : void 0,
                class: "orders"
              }, {
                default: withCtx(() => [
                  createVNode(_component_Tabs, {
                    "hide-contents": "",
                    items: unref(tabTitles),
                    modelValue: unref(activeTab),
                    "onUpdate:modelValue": ($event) => isRef(activeTab) ? activeTab.value = $event : null
                  }, null, 8, ["items", "modelValue", "onUpdate:modelValue"]),
                  createVNode(_component_Tabs, {
                    "hide-tabs": "",
                    items: unref(tabContents),
                    modelValue: unref(activeTab),
                    "onUpdate:modelValue": ($event) => isRef(activeTab) ? activeTab.value = $event : null
                  }, null, 8, ["items", "modelValue", "onUpdate:modelValue"])
                ]),
                _: 1
              }, 8, ["title"])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/orders/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=index-DI9sNJkr.js.map
