import { b as useRuntimeConfig, c as useNuxtApp } from "../server.mjs";
import { ref } from "vue";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "#internal/nuxt/paths";
import { defineStore } from "pinia";
const galleryStore = defineStore("gallery", () => {
  const activeMediaPath = ref(null);
  const files = ref([]);
  const { api } = useRuntimeConfig().public;
  const { $axios } = useNuxtApp();
  const groups = ref([
    { title: "رسمی", key: "official" }
  ]);
  const commentsMedia = ref([]);
  const activeGroup = ref("official");
  const selectedComment = ref(null);
  const slideIndex = ref(0);
  const init = (product) => {
    if (!product.videos) {
      product.videos = [];
    }
    files.value = [
      ...product.gallery.map((row) => ({
        ...row,
        group: "official"
      })),
      ...product.videos.map((row) => ({
        ...row,
        group: "official"
      }))
    ];
    commentsMedia.value = [];
    activeGroup.value = "official";
    groups.value = [
      { title: "رسمی", key: "official" }
    ];
  };
  const getCommentsMedia = (productId) => {
    $axios.get(api + "/product/" + productId + "/comment-media").then((response) => {
      commentsMedia.value = response.data.data;
      if (Array.isArray(commentsMedia.value) && commentsMedia.value.length > 0) {
        const rows = commentsMedia.value.flatMap(
          (row, index) => row.files.map((file) => ({
            path: file.path,
            group: "buyers",
            dataIndex: index
          }))
        );
        files.value = [...files.value, ...rows];
        console.log(rows);
        groups.value.push({
          title: "خریداران",
          key: "buyers"
        });
      }
    });
  };
  const onMainSlideChanged = (slide, index) => {
    activeGroup.value = slide.getAttribute("data-tag");
    slideIndex.value = index;
    const commentIndex = parseInt(slide.getAttribute("data-index"));
    if (commentIndex >= 0) {
      selectedComment.value = commentsMedia.value[commentIndex];
    } else {
      selectedComment.value = null;
    }
  };
  const changeMediaType = (key, product) => {
    activeGroup.value = key;
    if (activeGroup.value == "official") {
      slideIndex.value = 0;
    } else {
      slideIndex.value = product.gallery.length + product.videos.length;
    }
  };
  const slideShowBasedActivePath = (path) => {
    const index = files.value.findIndex((file) => file.path == path);
    if (index) {
      slideIndex.value = index;
    }
  };
  return {
    slideShowBasedActivePath,
    onMainSlideChanged,
    getCommentsMedia,
    init,
    changeMediaType,
    activeMediaPath,
    files,
    activeGroup,
    slideIndex,
    selectedComment,
    commentsMedia,
    groups
  };
});
export {
  galleryStore as g
};
//# sourceMappingURL=gallery-hwUJSkhT.js.map
