import { _ as _sfc_main$1 } from "./VerticalView-mV-jyVNN.js";
import { defineComponent, ref, withAsyncContext, computed, watch, mergeProps, unref, withCtx, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrRenderList, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import { u as useState, m as useFetch, b as useRuntimeConfig } from "../server.mjs";
import "./NuxtImg-DBEieluz.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "./v3-CqizLg04.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/@unhead/vue/dist/index.mjs";
import "./Skeleton-B5XQTW8R.js";
import "./Score-BYZAscMc.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "pinia";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "best-selling",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const categories = useState("categories");
    const theme = useState("theme");
    const lastDays = ref("week");
    const categoryId = ref(0);
    const { data: products, status } = ([__temp, __restore] = withAsyncContext(() => useFetch(
      useRuntimeConfig().public.api + "/shop/best-selling",
      {
        query: {
          category_id: categoryId
        }
      },
      "$erEqSrPlkm"
    )), __temp = await __temp, __restore(), __temp);
    const mainCategories = computed(() => {
      if (categories.value) {
        return categories.value.filter((category) => category.parent_id == 0);
      } else {
        return [];
      }
    });
    const updateBrowserUrl = () => {
      (void 0).history.pushState(
        {},
        "",
        useRuntimeConfig().public.appUrl + "/best-selling?category_id=" + categoryId.value + "&last_days=" + lastDays.value
      );
    };
    watch(() => categoryId.value, () => {
      updateBrowserUrl();
    });
    watch(() => lastDays.value, () => {
      updateBrowserUrl();
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeProductSliderVerticalView = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "best-selling" }, _attrs))}>`);
      if (unref(theme) == "desktop") {
        _push(`<div class="header"><h1 class="text-3xl font-bold"> پرفروش‌ترین‌ها </h1></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(theme) === "desktop") {
        _push(`<div class="css-idodb bg-white"><div class="css-qqyt7"></div><div class="css-6vk8q"><span class="${ssrRenderClass({ "active": unref(lastDays) == "week" })}"> ۷ روز گذشته </span><span class="${ssrRenderClass({ "active": unref(lastDays) == "month" })}"> ۳۰ روز گذشته </span></div><div class="css-qqyt7"></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div>`);
      if (unref(theme) == "desktop") {
        _push(`<div class="categories"><ul><li class="${ssrRenderClass({ "active": unref(categoryId) == 0 })}"><span>همه</span></li><!--[-->`);
        ssrRenderList(unref(mainCategories), (category) => {
          _push(`<li class="${ssrRenderClass({ "active": unref(categoryId) == category.id })}"><span>${ssrInterpolate(category.name)}</span></li>`);
        });
        _push(`<!--]--></ul></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ "vertical-list": unref(theme) == "mobile" }, "grid sm:grid-cols-2 md:grid-cols-4 lg:grid-cols-5 pb-10"])}">`);
      if (unref(status) == "success") {
        _push(`<!--[-->`);
        ssrRenderList(unref(products), (product, key) => {
          _push(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
            key: product.id,
            product,
            "show-colors": "",
            "show-score": "",
            index: key + 1
          }, {
            before: withCtx(({ index }, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="w-full"${_scopeId}><div class="max-md:rounded-lg md:rounded-l-lg bg-cyan-400 text-white w-[30px] text-center"${_scopeId}>${ssrInterpolate(_ctx.$replaceEnNumber(index.toString()))}</div></div>`);
              } else {
                return [
                  createVNode("div", { class: "w-full" }, [
                    createVNode("div", { class: "max-md:rounded-lg md:rounded-l-lg bg-cyan-400 text-white w-[30px] text-center" }, toDisplayString(_ctx.$replaceEnNumber(index.toString())), 1)
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        ssrRenderList(10, (i) => {
          _push(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
            key: i,
            loading: "",
            product: null
          }, null, _parent));
        });
        _push(`<!--]-->`);
      }
      _push(`</div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/best-selling.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=best-selling-B6wMiiTP.js.map
