import { defineComponent, mergeProps, useSSRContext, resolveComponent, createVNode, resolveDynamicComponent, computed, unref } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderComponent, ssrRenderStyle, ssrRenderVNode, ssrRenderAttr, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$6 } from "./MoreText-CtkeWBXn.js";
import { p as productStore, b as useRuntimeConfig } from "../server.mjs";
import { g as galleryStore } from "./gallery-hwUJSkhT.js";
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "Info",
  __ssrInlineRender: true,
  props: {
    comment: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center" }, _attrs))}>`);
      if (_ctx.comment.user) {
        _push(`<span>${ssrInterpolate(_ctx.comment.user.name)}</span>`);
      } else {
        _push(`<span>ناشناس</span>`);
      }
      if (_ctx.comment.score) {
        _push(`<div class="d-table bg-green-100 text-green-700 text-xs mx-2 px-2 flex items-center rounded-lg"> خریدار </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/user/Info.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "StarRating",
  __ssrInlineRender: true,
  props: {
    rating: {}
  },
  setup(__props) {
    const props = __props;
    function getStarFillPercentage(index) {
      const currentStar = index + 1;
      if (props.rating >= currentStar) {
        return 100;
      } else if (props.rating > index) {
        return (props.rating - index) * 100 / 2;
      }
      return 0;
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center" }, _attrs))}><!--[-->`);
      ssrRenderList(5, (star, index) => {
        _push(`<div class="relative w-5 h-5">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "star"],
          class: "text-gray-300"
        }, null, _parent));
        _push(`<div class="absolute inset-0 overflow-hidden" style="${ssrRenderStyle({ width: `${getStarFillPercentage(index)}%` })}">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "star"],
          class: "text-yellow-400"
        }, null, _parent));
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/StarRating.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "VariationDetail",
  __ssrInlineRender: true,
  props: {
    comment: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.comment.variation) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "text-sm" }, _attrs))}>`);
        if (_ctx.comment.variation.seller) {
          _push(`<div class="flex pt-2 items-center">`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "home"],
            class: "text-gray-500"
          }, null, _parent));
          _push(`<span class="pr-1.5">${ssrInterpolate(_ctx.comment.variation.seller.brandName)}</span>`);
          if (_ctx.$variationParamComponent(_ctx.comment.variation.param1_type)) {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(_ctx.comment.variation.param1_type)), {
              data: _ctx.comment.variation.param1,
              class: "pr-2"
            }, null), _parent);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/VariationDetail.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "LikeDislikeSection",
  __ssrInlineRender: true,
  props: {
    comment: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex text-gray-600" }, _attrs))}><div class="px-2 cursor-pointer"><span>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.comment.like))}</span>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["far", "fa-thumbs-up"],
        class: "pr-2"
      }, null, _parent));
      _push(`</div><div class="px-2 cursor-pointer"><span>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.comment.like))}</span>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["far", "fa-thumbs-down"],
        class: "pr-2"
      }, null, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/LikeDislikeSection.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "TimeAgo",
  __ssrInlineRender: true,
  props: {
    time: {}
  },
  setup(__props) {
    const props = __props;
    const timeAgo = function() {
      const now = /* @__PURE__ */ new Date();
      const difference = Math.floor(now.getTime() / 1e3) - props.time;
      const minutes = Math.floor(difference / 60);
      const hours = Math.floor(minutes / 60);
      const days = Math.floor(hours / 24);
      if (difference < 60) {
        return "لحظاتی پیش";
      } else if (minutes < 60) {
        return `${minutes} دقیقه پیش`;
      } else if (hours < 24) {
        return `${hours} ساعت پیش`;
      } else if (days < 7) {
        return `${days} روز پیش`;
      } else if (days < 30) {
        const weeks = Math.floor(days / 7);
        return `${weeks} هفته پیش`;
      } else if (days < 365) {
        const months = Math.floor(days / 30);
        return `${months} ماه پیش`;
      } else {
        const years = Math.floor(days / 365);
        return `${years} سال پیش`;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<p${ssrRenderAttrs(mergeProps({ class: "text-gray-500 text-sm py-1" }, _attrs))}>${ssrInterpolate(_ctx.$replaceEnNumber(timeAgo()))}</p>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/TimeAgo.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "View",
  __ssrInlineRender: true,
  props: {
    comment: {},
    selectedMedia: { type: Function },
    hideUser: { type: Boolean }
  },
  setup(__props) {
    productStore();
    const gallery = galleryStore();
    const { serverUrl } = useRuntimeConfig().public;
    const props = __props;
    const commentMedia = computed(() => {
      return gallery.commentsMedia.find((media) => media.comment_id == props.comment.id);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommentUserInfo = _sfc_main$5;
      const _component_CommentStarRating = _sfc_main$4;
      const _component_ThemeWidgetsMoreText = _sfc_main$6;
      const _component_CommentVariationDetail = _sfc_main$3;
      const _component_CommentLikeDislikeSection = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-6" }, _attrs))}><div><div class="flex">`);
      if (!_ctx.hideUser) {
        _push(ssrRenderComponent(_component_CommentUserInfo, { comment: _ctx.comment }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$1, {
        time: _ctx.comment.created_at,
        class: "text-gray-400 text-xs mr-1"
      }, null, _parent));
      _push(`</div></div>`);
      if (_ctx.comment.buyer == 1 && _ctx.comment.score) {
        _push(ssrRenderComponent(_component_CommentStarRating, {
          rating: _ctx.comment.score,
          class: "mt-2"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (_ctx.comment.text) {
        _push(ssrRenderComponent(_component_ThemeWidgetsMoreText, {
          text: _ctx.comment.text,
          length: 300,
          class: "!text-black mt-5"
        }, null, _parent));
      } else {
        _push(`<!--[--><p class="text-sm text-gray-500 my-4">ویس ارسال شده توسط کاربر</p><audio class="w-full lg:max-w-[500px] mb-10"${ssrRenderAttr("src", unref(serverUrl) + "/" + _ctx.comment.voice)} controls></audio><!--]-->`);
      }
      _push(ssrRenderComponent(_component_CommentVariationDetail, { comment: _ctx.comment }, null, _parent));
      if (unref(commentMedia) && unref(commentMedia).files.length > 0) {
        _push(`<div class="flex flex-wrap mt-3"><!--[-->`);
        ssrRenderList(unref(commentMedia).files, (file, key) => {
          _push(`<div class="${ssrRenderClass([{ "px-2": key > 0, "pl-2": key == 0 }, "cursor-pointer"])}">`);
          if (file.path.toString().indexOf("mp4") == -1) {
            _push(`<img${ssrRenderAttr("src", unref(serverUrl) + "/" + file.path)} class="w-10 h-10 rounded-md lg:w-14 lg:h-14" alt="">`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="mt-2 flex justify-end items-center">`);
      _push(ssrRenderComponent(_component_CommentLikeDislikeSection, { comment: _ctx.comment }, null, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/View.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main$4 as _,
  _sfc_main as a,
  _sfc_main$2 as b,
  _sfc_main$5 as c,
  _sfc_main$1 as d
};
//# sourceMappingURL=View-BN6pemn-.js.map
