import { e as useRoute, c as useNuxtApp, h as _sfc_main$1, g as __nuxt_component_0, b as useRuntimeConfig } from "../server.mjs";
import { defineComponent, ref, computed, resolveComponent, mergeProps, unref, withCtx, createTextVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Verify",
  __ssrInlineRender: true,
  setup(__props) {
    useRoute();
    const loading = ref(false);
    const order = ref(null);
    const paymentMethods = useNuxtApp().vueApp.config.globalProperties["$payment:methods"];
    const paymentMethod = computed(() => {
      if (order.value && paymentMethods) {
        const method = paymentMethods.find((method2) => method2.name == order.value.payment_method);
        if (method) {
          return method.title;
        }
      }
      return "";
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Loading = _sfc_main$1;
      const _component_nuxt_link = __nuxt_component_0;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "verify-checkout flex flex-col items-center py-10" }, _attrs))}>`);
      if (unref(loading)) {
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
      } else {
        _push(`<!--[-->`);
        if (unref(order) != null && unref(order).status == "ok") {
          _push(`<div class="content lg:border rounded-lg"><div class="max-md:w-full"><h4 class="text-gray-600">سفارش شما با موفقیت ثبت شد</h4><ul class="py-3 pa-h-0 ma-0"><li class="py-3"><span>شماره سفارش : </span><span class="font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(unref(order).order_code))}</span></li><li class="py-3"><span>روش پرداخت : </span><span class="font-bold">${ssrInterpolate(unref(paymentMethod))}</span></li></ul><div>`);
          _push(ssrRenderComponent(_component_nuxt_link, {
            class: "btn btn-danger p-3 text-sm",
            to: "/profile/orders"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` ویرایش و پیگیری سفارش `);
              } else {
                return [
                  createTextVNode(" ویرایش و پیگیری سفارش ")
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(ssrRenderComponent(_component_nuxt_link, {
            class: "!text-red-600 mx-2.5 fs-15",
            to: "/"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` بازگشت به صفحه اصلی `);
              } else {
                return [
                  createTextVNode(" بازگشت به صفحه اصلی ")
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div><div class="max-md:w-full"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/order-success.svg")} alt="order-success"></div></div>`);
        } else {
          _push(`<div class="content lg:border rounded-lg"><div class="max-md:w-full"><h4 class="!text-red-600"> متاسفانه پرداخت شما ناموفق بود! </h4><div class="text-gray-600 py-5">`);
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "fa-info"] }, null, _parent));
          _push(`<span> چنانچه مبلغی از حساب شما کسر شده است، تا ۲۴ ساعت آینده به حساب شما باز خواهد گشت. </span></div><div><button class="c-btn text-sm px-5"> پرداخت دوباره </button></div></div><div class="max-md:w-full"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/order-Fail.svg")} alt="order-fail"></div></div>`);
        }
        _push(`<!--]-->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/Verify.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=Verify-hxF_WJkP.js.map
