import { _ as _sfc_main$1 } from "./VerticalView-mV-jyVNN.js";
import { _ as _sfc_main$2 } from "./RemoveRequestBtn-CGRu9Gzt.js";
import { _ as _sfc_main$3 } from "./Pagination-BRp8RD1E.js";
import { defineComponent, ref, resolveComponent, unref, withCtx, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrRenderList, ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { c as useNuxtApp, b as useRuntimeConfig } from "../server.mjs";
import "./NuxtImg-DBEieluz.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "./v3-CqizLg04.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/@unhead/vue/dist/index.mjs";
import "./Skeleton-B5XQTW8R.js";
import "./Score-BYZAscMc.js";
import "./user-utils-B9JSuaai.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "pinia";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "UserList",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = ref("theme");
    const list = ref({ data: [] });
    const loading = ref(false);
    const getList = (page = 1) => {
      loading.value = true;
      if (page > 1) {
        const pageContent = (void 0).querySelector(".page-content");
        pageContent.scrollTo(0, 0);
      }
      useNuxtApp().$axios.get(
        useRuntimeConfig().public.staticApi + "/response.php?file=product-notification-list&page=" + page
      ).then((response) => {
        loading.value = false;
        list.value = response.data;
      }).catch(() => {
        loading.value = false;
      });
    };
    const removeProductFromList = () => {
      getList();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeProductSliderVerticalView = _sfc_main$1;
      const _component_UsersRemoveRequestBtn = _sfc_main$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Pagination = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="${ssrRenderClass([{ "vertical-list": unref(theme) != "desktop" }, "grid lg:grid-cols-2"])}">`);
      if (!unref(loading)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(list).data, (product) => {
          _push(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
            key: product.id,
            product
          }, {
            after: withCtx(({ product: product2 }, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="flex items-center justify-between pt-3 text-sm"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_UsersRemoveRequestBtn, {
                  then: removeProductFromList,
                  id: product2.id,
                  title: "حذف از لیست اطلاع رسانی",
                  description: "آیا از حذف " + product2.title + " از لیست علاقه مندی ها اطمینان دارید؟",
                  deleteBtnText: "حذف کالا"
                }, null, _parent2, _scopeId));
                _push2(`<div class="text-gray-500"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "bell"] }, null, _parent2, _scopeId));
                _push2(`<span class="pr-2"${_scopeId}>${ssrInterpolate(product2["notification-type"])}</span></div></div>`);
              } else {
                return [
                  createVNode("div", { class: "flex items-center justify-between pt-3 text-sm" }, [
                    createVNode(_component_UsersRemoveRequestBtn, {
                      then: removeProductFromList,
                      id: product2.id,
                      title: "حذف از لیست اطلاع رسانی",
                      description: "آیا از حذف " + product2.title + " از لیست علاقه مندی ها اطمینان دارید؟",
                      deleteBtnText: "حذف کالا"
                    }, null, 8, ["id", "description"]),
                    createVNode("div", { class: "text-gray-500" }, [
                      createVNode(_component_fa_icon, { icon: ["fas", "bell"] }),
                      createVNode("span", { class: "pr-2" }, toDisplayString(product2["notification-type"]), 1)
                    ])
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        ssrRenderList(10, (i) => {
          _push(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
            key: i,
            loading: "",
            product: null
          }, null, _parent));
        });
        _push(`<!--]-->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_Pagination, {
        data: unref(list),
        "fetch-data": getList,
        offset: 4,
        class: "my-5"
      }, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/notifications/UserList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=UserList-B2MDmyc8.js.map
