import { ref, inject, watch, defineComponent, mergeModels, useModel, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderSlot, ssrRenderAttr, ssrRenderDynamicModel, ssrIncludeBooleanAttr, ssrRenderComponent } from "vue/server-renderer";
import { c as useNuxtApp } from "../server.mjs";
function useValidate(props, model) {
  const error = ref(false);
  const isValid = ref(false);
  const functions = {
    min(value, label, length) {
      if (value.toString().trim().length < +length) {
        return `${label} حداقل باید دارای ${length} کاراکتر باشد`;
      }
      return true;
    },
    max(value, label, length) {
      if (value.toString().trim().length > +length) {
        return `${label} حداکثر باید دارای ${length} کاراکتر باشد`;
      }
      return true;
    },
    nationalCode(value, label) {
      if (!isNaN(parseInt(value)) && value.toString().length === 10) {
        let sum = 0;
        for (let i = 0; i < 9; i++) {
          sum += (10 - i) * parseInt(value[i]);
        }
        const ret = sum % 11;
        const parity = parseInt(value[9]);
        if (ret < 2 && ret === parity || ret >= 2 && ret === 11 - parity) {
          return true;
        }
      }
      return `${label} معتبر نمی باشد`;
    },
    required(value, label) {
      if (value == null || value.toString().trim() === "") {
        return `${label} نمی تواند خالی باشد`;
      }
      return true;
    },
    mobile(value, label) {
      if (!isNaN(value)) {
        value = parseInt(value);
        if (value.toString().length === 10 && value.toString().charAt(0) === "9") {
          return true;
        }
      }
      return `${label} وارد شده معتبر نمی باشد`;
    },
    length(value, label, length) {
      if (value.toString().trim().length !== +length) {
        return `${label} باید شامل ${length} کاراکتر باشد`;
      }
      return true;
    },
    email(value, label) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!value.toString().trim().match(emailRegex)) {
        return `${label} باید یک ایمیل معتبر باشد`;
      }
      return true;
    }
  };
  const validate = (value, rules, label) => {
    const parsedRules = typeof rules === "string" ? rules.split("|") : rules;
    for (const rule of parsedRules) {
      let result = true;
      if (typeof rule === "function") {
        result = rule(value, label);
      } else {
        const [name, param] = rule.split(":");
        const fn = functions[name];
        if (fn) {
          result = fn(value, label, param);
        }
      }
      if (result !== true) {
        return result;
      }
    }
    return true;
  };
  const validateInput = () => {
    let result = true;
    if (props.rules) {
      result = validate(model.value, props.rules, props.label);
    }
    error.value = result === true ? false : result;
    isValid.value = result === true;
    return result;
  };
  const inputKeyUp = () => {
    validateInput();
  };
  const checknationalCode = (value, label) => {
    if (!isNaN(parseInt(value)) && value.length === 10) {
      let sum = 0;
      for (let i = 0; i < 9; i++) {
        sum += (10 - i) * parseInt(value[i]);
      }
      const ret = sum % 11;
      const parity = parseInt(value[9]);
      if (ret < 2 && ret === parity || ret >= 2 && ret === 11 - parity) {
        return true;
      }
    }
    return `${label} معتبر نمی باشد`;
  };
  return {
    error,
    isValid,
    functions,
    inputKeyUp,
    validateInput,
    checknationalCode
  };
}
function useTextInput(props, model, realValue) {
  const passwordIcon = ref("eye");
  const inputType = ref(props.type || "input");
  const { error, isValid, inputKeyUp, validateInput } = useValidate(props, model);
  inject("addRule");
  const global = useNuxtApp().vueApp.config.globalProperties;
  const validate = () => {
    return validateInput();
  };
  const checkKeyDown = ($event) => {
    if (props.type === "number") {
      const n = $event.key;
      if (n !== "Backspace" && isNaN(Number(n)) && n !== "." && n !== "-") {
        $event.preventDefault();
      }
    }
  };
  const getFormatedValue = (value) => {
    if (props.separator) {
      return global.$replaceEnNumber(
        global.$numberFormat(
          value.toString().replace(new RegExp(props.separator, "g"), ""),
          props.separator,
          props.digit
        )
      );
    }
    return value;
  };
  const getRealValue = (value) => {
    if (value || value === 0) {
      return global.$replaceFaNumber(
        value.toString().replace(new RegExp(props.separator, "g"), "")
      );
    }
    return 0;
  };
  const changePasswordInputType = () => {
    inputType.value = inputType.value === "password" ? "text" : "password";
    passwordIcon.value = inputType.value === "password" ? "eye-slash" : "eye";
  };
  watch(() => realValue.value, () => {
    model.value = getFormatedValue(parseInt(realValue.value));
  });
  watch(() => model.value, (newValue) => {
    if (props.type === "number" && newValue !== getFormatedValue(model.value)) {
      realValue.value = getRealValue(model.value);
      model.value = getFormatedValue(model.value);
    }
  });
  return {
    error,
    inputKeyUp,
    validate,
    checkKeyDown,
    getFormatedValue,
    getRealValue,
    changePasswordInputType,
    isValid,
    passwordIcon,
    inputType
  };
}
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "TextInput",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    disable: Boolean,
    label: String,
    hideLabel: Boolean,
    placeholder: String,
    rules: [String, Array],
    name: { type: String, required: true },
    type: { type: String, default: "input" },
    separator: String,
    digit: Number,
    enter: Function,
    autofocus: Boolean
  }, {
    "modelValue": {},
    "modelModifiers": {},
    "real": {},
    "realModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["focusout"], ["update:modelValue", "update:real"]),
  setup(__props, { emit: __emit }) {
    const props = __props;
    const model = useModel(__props, "modelValue");
    const realValue = useModel(__props, "real");
    const {
      passwordIcon,
      inputType,
      error,
      isValid,
      changePasswordInputType
    } = useTextInput(props, model, realValue);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["input-box relative base-space", { "disable": __props.disable }]
      }, _attrs))}>`);
      if (!__props.hideLabel) {
        _push(`<label>${ssrInterpolate(__props.label)}</label>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ "border border-red-400": unref(error) }, "flex input justify-between px-2"])}">`);
      ssrRenderSlot(_ctx.$slots, "perfix", {}, null, _push, _parent);
      if (unref(inputType) !== "textarea") {
        _push(`<input class="form-control w-full"${ssrIncludeBooleanAttr(__props.disable) ? " disabled" : ""}${ssrRenderAttr("placeholder", __props.placeholder || "")}${ssrRenderDynamicModel(unref(inputType) === "number" ? "text" : unref(inputType), model.value, null)}${ssrRenderAttr("type", unref(inputType) === "number" ? "text" : unref(inputType))}${ssrRenderAttr("id", "input-" + __props.name)}${ssrIncludeBooleanAttr(__props.autofocus) ? " autofocus" : ""}>`);
      } else {
        _push(`<textarea class="form-control h-28 resize-none peer"${ssrIncludeBooleanAttr(__props.disable) ? " disabled" : ""}${ssrRenderAttr("placeholder", __props.placeholder ?? "")}${ssrRenderAttr("id", "input-" + __props.name)}>${ssrInterpolate(model.value)}</textarea>`);
      }
      _push(`<div class="flex items-center">`);
      if (__props.type === "password") {
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["far", unref(passwordIcon)],
          onClick: unref(changePasswordInputType),
          class: "px-3"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      ssrRenderSlot(_ctx.$slots, "suffix", {}, null, _push, _parent);
      _push(`</div>`);
      if (realValue.value) {
        _push(`<input type="hidden"${ssrRenderAttr("name", __props.name)}${ssrRenderAttr("value", realValue.value)} class="c-input">`);
      } else {
        _push(`<input type="hidden"${ssrRenderAttr("name", __props.name)}${ssrRenderAttr("value", model.value)} class="c-input">`);
      }
      if (!unref(isValid)) {
        _push(`<div class="has-error"></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(error) !== false) {
        _push(`<div class="error text-red-500 text-[14px] py-1">${ssrInterpolate(unref(error))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/TextInput.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=TextInput-BtVMT3NE.js.map
