import { mergeModels, useModel, createVNode, resolveDynamicComponent, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderClass, ssrInterpolate, ssrRenderSlot, ssrRenderAttr, ssrRenderVNode } from "vue/server-renderer";
const _sfc_main = {
  __name: "Tabs",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    items: {
      type: Array
    },
    showAllContent: {
      type: Boolean
    },
    changedTab: {
      type: Boolean
    },
    hideContents: {
      type: Boolean
    },
    hideTabs: {
      type: Boolean
    }
  }, {
    "modelValue": {},
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const props = __props;
    const activeTab = useModel(__props, "modelValue");
    activeTab.value = 0;
    const changeTab = function(key, callback = true) {
      activeTab.value = key;
      if (props.changedTab && callback === true) {
        props.changedTab(key);
      }
    };
    __expose({ changeTab });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (!__props.hideTabs) {
        _push(`<div class="flex justify-between tabs items-center border-b z-10"><ul class="c-tab w-full"><!--[-->`);
        ssrRenderList(__props.items, (item, key) => {
          _push(`<li><button class="${ssrRenderClass([{ "active": activeTab.value === key }, "flex justify-center items-center"])}" type="button">${ssrInterpolate(item.title)} `);
          if (item.count && item.count > 0) {
            _push(`<div class="count">${ssrInterpolate(_ctx.$replaceEnNumber(item.count))}</div>`);
          } else {
            _push(`<!---->`);
          }
          ssrRenderSlot(_ctx.$slots, "tab-" + item.name, {
            active: activeTab.value === key
          }, null, _push, _parent);
          _push(`</button></li>`);
        });
        _push(`<!--]--></ul>`);
        ssrRenderSlot(_ctx.$slots, "leading", {}, null, _push, _parent);
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (!__props.hideContents) {
        _push(`<div class="!p-0 w-full content">`);
        if (!__props.showAllContent) {
          _push(`<!--[-->`);
          ssrRenderList(__props.items, (item, key) => {
            _push(`<div${ssrRenderAttr("id", item.name)}>`);
            if (!__props.showAllContent && activeTab.value === key) {
              _push(`<!--[-->`);
              if (!item.component) {
                ssrRenderSlot(_ctx.$slots, item.name, {}, null, _push, _parent);
              } else {
                _push(`<!---->`);
              }
              ssrRenderVNode(_push, createVNode(resolveDynamicComponent(item.component), {
                tab: item,
                activeTab: activeTab.value
              }, null), _parent);
              _push(`<!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (__props.showAllContent) {
          ssrRenderSlot(_ctx.$slots, "all-content", { activeTab: activeTab.value }, null, _push, _parent);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Tabs.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=Tabs-CzUlKuXU.js.map
