import { defineComponent, mergeProps, useSSRContext, ref, computed, watch, resolveComponent, unref, createVNode, resolveDynamicComponent, withCtx, createBlock, openBlock, Fragment, renderList } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent, ssrRenderVNode, ssrRenderList } from "vue/server-renderer";
import { a as addressStore, _ as _sfc_main$4 } from "./CreateOrEdit-LLCfqsZZ.js";
import { u as useState, _ as _sfc_main$2, a as _sfc_main$3 } from "../server.mjs";
import { useRouter } from "vue-router";
import "./TextInput-BtVMT3NE.js";
import "@vue-leaflet/vue-leaflet";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "pinia";
import "./Component-C6QGchKb.js";
import "./user-utils-B9JSuaai.js";
import "./SelectTag-Cc2QTMT4.js";
import "./input-CqSTwEhb.js";
import "ofetch";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ShortDetail",
  __ssrInlineRender: true,
  props: {
    address: {},
    active: { type: Boolean },
    selectAddress: { type: Function }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "leading-8 lg:text-[15px] cursor-pointer" }, _attrs))}><p class="${ssrRenderClass({ "text-cyan-500": _ctx.active })}">${ssrInterpolate(_ctx.address.address)}</p><p><span>کد پستی : </span><span class="px-1.5">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.address.postalCode))}</span></p>`);
      if (_ctx.address.recipient_name && _ctx.address.recipient_mobile_number) {
        _push(`<p><span>گیرنده : </span><span class="px-1.5"><span>${ssrInterpolate(_ctx.address.recipient_name + " " + _ctx.address.recipient_last_name)}</span> ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.address.recipient_mobile_number))}</span></p>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/ShortDetail.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const useAddressSelection = () => {
  const selectBoxRef = ref(null);
  const selectedAddressId = useState("selected-address-id");
  const addressState = addressStore();
  const toast = useState("toast");
  const router = useRouter();
  const selectedAddress = computed(
    () => addressState.addresses.find((address) => address.id === selectedAddressId.value) || null
  );
  const changeAddress = (address) => {
    var _a;
    selectedAddressId.value = address.id;
    (_a = selectBoxRef.value) == null ? void 0 : _a.hide();
  };
  const showCreateForm = () => {
    var _a;
    (_a = selectBoxRef.value) == null ? void 0 : _a.hide();
    addressState.showCreateForm();
  };
  const showEditForm = (address) => {
    var _a;
    (_a = selectBoxRef.value) == null ? void 0 : _a.hide();
    addressState.showEditForm(address.id);
  };
  watch(
    () => addressState.addresses,
    () => {
      if (addressState.addresses.length > 0 && !selectedAddressId.value) {
        selectedAddressId.value = addressState.addresses[0].id;
      } else if (addressState.addresses.length === 0) {
        toast.value = {
          message: "برای ثبت سفارش باید ابتدا آدرس خود را ثبت کنید",
          type: "error"
        };
        router.push("/profile/addresses");
      }
    }
  );
  return {
    selectBoxRef,
    addressState,
    selectedAddress,
    changeAddress,
    showCreateForm,
    showEditForm
  };
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SelectionList",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const {
      selectBoxRef,
      addressState,
      selectedAddress,
      changeAddress,
      showCreateForm,
      showEditForm
    } = useAddressSelection();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_AddressesShortDetail = _sfc_main$1;
      const _component_AddressesCreateOrEdit = _sfc_main$4;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "address-selection-list" }, _attrs))}>`);
      if (unref(selectedAddress)) {
        _push(`<div class="flex items-center border cursor-pointer px-3 py-4 border-cyan-400 rounded-md">`);
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "truck"] }, null, _parent));
        _push(`<div class="flex-grow pr-3"><div class="w-full flex justify-between text-cyan-400 text-sm"><span>ارسال به آدرس انتخاب شده</span><button class="flex items-center"><span>تغییر آدرس</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "angle-left"],
          class: "pr-2"
        }, null, _parent));
        _push(`</button></div><div class="text-gray-500 pt-3">${ssrInterpolate(unref(selectedAddress).address)}</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$2 : _sfc_main$3), {
        ref_key: "selectBoxRef",
        ref: selectBoxRef,
        title: "آدرس‌های شما",
        direction: "bottom",
        "content-class": "w-full h-full bottom-0"
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="border-t p-5"${_scopeId}><button class="text-red-600"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "plus"] }, null, _parent2, _scopeId));
            _push2(`<span class="pr-2"${_scopeId}>افزودن آدرس جدید</span></button></div>`);
          } else {
            return [
              createVNode("div", { class: "border-t p-5" }, [
                createVNode("button", {
                  class: "text-red-600",
                  onClick: ($event) => unref(showCreateForm)()
                }, [
                  createVNode(_component_fa_icon, { icon: ["fas", "plus"] }),
                  createVNode("span", { class: "pr-2" }, "افزودن آدرس جدید")
                ], 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(unref(addressState).addresses, (address) => {
              var _a, _b, _c, _d;
              _push2(`<div class="px-3"${_scopeId}><div class="${ssrRenderClass([{ "!border-black": ((_a = unref(selectedAddress)) == null ? void 0 : _a.id) == address.id }, "w-full flex p-3 justify-between items-center border rounded-md my-5"])}"${_scopeId}><div class="flex items-center text-gray-600"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "location-dot"],
                class: { "text-cyan-500": ((_b = unref(selectedAddress)) == null ? void 0 : _b.id) == address.id }
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_AddressesShortDetail, {
                address,
                class: "pr-4",
                "select-address": unref(changeAddress),
                active: ((_c = unref(selectedAddress)) == null ? void 0 : _c.id) == address.id
              }, null, _parent2, _scopeId));
              _push2(`</div><button class="${ssrRenderClass({ "text-cyan-500": ((_d = unref(selectedAddress)) == null ? void 0 : _d.id) == address.id })}"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_fa_icon, { icon: ["far", "edit"] }, null, _parent2, _scopeId));
              _push2(`</button></div></div>`);
            });
            _push2(`<!--]-->`);
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(unref(addressState).addresses, (address) => {
                var _a, _b, _c, _d;
                return openBlock(), createBlock("div", {
                  key: address.id,
                  class: "px-3"
                }, [
                  createVNode("div", {
                    class: ["w-full flex p-3 justify-between items-center border rounded-md my-5", { "!border-black": ((_a = unref(selectedAddress)) == null ? void 0 : _a.id) == address.id }]
                  }, [
                    createVNode("div", { class: "flex items-center text-gray-600" }, [
                      createVNode(_component_fa_icon, {
                        icon: ["fas", "location-dot"],
                        class: { "text-cyan-500": ((_b = unref(selectedAddress)) == null ? void 0 : _b.id) == address.id }
                      }, null, 8, ["class"]),
                      createVNode(_component_AddressesShortDetail, {
                        address,
                        class: "pr-4",
                        "select-address": unref(changeAddress),
                        active: ((_c = unref(selectedAddress)) == null ? void 0 : _c.id) == address.id
                      }, null, 8, ["address", "select-address", "active"])
                    ]),
                    createVNode("button", {
                      onClick: ($event) => unref(showEditForm)(address),
                      class: { "text-cyan-500": ((_d = unref(selectedAddress)) == null ? void 0 : _d.id) == address.id }
                    }, [
                      createVNode(_component_fa_icon, { icon: ["far", "edit"] })
                    ], 10, ["onClick"])
                  ], 2)
                ]);
              }), 128))
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(ssrRenderComponent(_component_AddressesCreateOrEdit, null, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/addresses/SelectionList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=SelectionList-unCKEwQ_.js.map
