import { u as useState, g as __nuxt_component_0 } from "../server.mjs";
import { defineComponent, computed, ref, resolveComponent, unref, mergeProps, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate } from "vue/server-renderer";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SearchSelectionCategory",
  __ssrInlineRender: true,
  props: {
    category_id: {},
    hideTitle: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const categories = useState("categories");
    const filteredCategories = computed(() => {
      return categories.value.filter(
        (category) => category.parent_id == props.category_id && !category.url
      );
    });
    const showList = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_nuxt_link = __nuxt_component_0;
      if (unref(filteredCategories).length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "filter-box" }, _attrs))}>`);
        if (!_ctx.hideTitle) {
          _push(`<div class="title"><div class="flex items-center"> دسته بندی ها </div>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            class: "text-gray-500",
            icon: ["fas", unref(showList) ? "fa-angle-up" : "fa-angle-down"]
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(showList) || _ctx.hideTitle) {
          _push(`<div class="content"><ul class="p-0"><!--[-->`);
          ssrRenderList(unref(filteredCategories), (category) => {
            _push(`<li class="flex items-center py-3">`);
            _push(ssrRenderComponent(_component_nuxt_link, {
              to: "/search/" + category.slug
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(category.name)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(category.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</li>`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/categories/SearchSelectionCategory.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=SearchSelectionCategory-crvf2Kwt.js.map
