import { d as _sfc_main$1 } from "../server.mjs";
import { defineComponent, ref, watch, resolveComponent, unref, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList } from "vue/server-renderer";
import { s as searchStore } from "./search-products-xw_89Bg_.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SearchSelectionCategory",
  __ssrInlineRender: true,
  props: {
    category_id: {},
    hideTitle: { type: Boolean }
  },
  setup(__props) {
    const store = searchStore();
    const categories = ref([]);
    const showList = ref(false);
    const selectedCategories = ref({});
    const addOrRemoveFilter = (id, status) => {
      store.addOrRemoveFilter("categories", id);
    };
    watch(() => store.queries, () => {
      if (Object.keys(store.queries).length === 0) {
        selectedCategories.value = {};
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormCheckBox = _sfc_main$1;
      if (unref(categories).length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "filter-box" }, _attrs))}>`);
        if (!_ctx.hideTitle) {
          _push(`<div class="title"><div class="flex items-center"> دسته بندی ها `);
          if (unref(store).queries["categories"]) {
            _push(`<div class="w-1 h-1 rounded-full bg-blue-400 mx-1"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            class: "text-gray-500",
            icon: ["fas", unref(showList) ? "fa-angle-up" : "fa-angle-down"]
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(showList) || _ctx.hideTitle) {
          _push(`<div class="content"><ul class="p-0"><!--[-->`);
          ssrRenderList(unref(categories), (category) => {
            _push(`<li class="flex items-center py-3">`);
            _push(ssrRenderComponent(_component_FormCheckBox, {
              label: category.name,
              name: category.id,
              afterClick: addOrRemoveFilter,
              modelValue: unref(selectedCategories)[category.id],
              "onUpdate:modelValue": ($event) => unref(selectedCategories)[category.id] = $event
            }, null, _parent));
            _push(`</li>`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/brands/SearchSelectionCategory.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=SearchSelectionCategory-DYowU9wa.js.map
