import { _ as _sfc_main$1 } from "./TextInput-BtVMT3NE.js";
import { h as _sfc_main$2, c as useNuxtApp, b as useRuntimeConfig } from "../server.mjs";
import { defineComponent, ref, unref, isRef, withCtx, createVNode, createBlock, openBlock, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass, ssrInterpolate } from "vue/server-renderer";
import { u as useOrderStore } from "./index-Co4X6G3O.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "RegisterCode",
  __ssrInlineRender: true,
  setup(__props) {
    const code = ref(null);
    const successMessage = ref(null);
    const errorMessage = ref(null);
    const loading = ref(false);
    const order = useOrderStore();
    const sendRequest = () => {
      if (code.value && code.value.length >= 3) {
        loading.value = true;
        useNuxtApp().$axios.post(
          useRuntimeConfig().public.staticApi + "/response.php?file=status-ok",
          {
            "code": code.value
          }
        ).then((response) => {
          loading.value = false;
          if (response.data.status == "ok") {
            code.value = null;
            successMessage.value = "کد تخفیف وارد شده صحیح می باشد";
            order.updateItemsDeducted({
              ...order.itemsDeducted,
              ...{ discount: { title: "تخفیف", value: 1e5 } }
            });
          }
          setTimeout(() => {
            successMessage.value = null;
            errorMessage.value = null;
          }, 4e3);
        }).catch(() => {
          loading.value = false;
        });
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$1;
      const _component_Loading = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(_attrs)}><div><span class="font-bold">کد تخفیف</span></div><div><p class="text-gray-400 py-3"> در صورت داشتن کد تخفیف میتوانید وارد نمایید </p>`);
      _push(ssrRenderComponent(_component_FormTextInput, {
        class: "w-full md:w-1/2",
        placeholder: "وارد کردن کد تخفیف",
        modelValue: unref(code),
        "onUpdate:modelValue": ($event) => isRef(code) ? code.value = $event : null
      }, {
        suffix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="px-3 flex items-center cursor-pointer"${_scopeId}>`);
            if (!unref(loading)) {
              _push2(`<span class="${ssrRenderClass([unref(code) ? "text-black" : "text-gray-400"])}"${_scopeId}> ثبت </span>`);
            } else {
              _push2(ssrRenderComponent(_component_Loading, null, null, _parent2, _scopeId));
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: "px-3 flex items-center cursor-pointer",
                onClick: sendRequest
              }, [
                !unref(loading) ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: [unref(code) ? "text-black" : "text-gray-400"]
                }, " ثبت ", 2)) : (openBlock(), createBlock(_component_Loading, { key: 1 }))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(successMessage)) {
        _push(`<div class="alert alert-success">${ssrInterpolate(unref(successMessage))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/discount/RegisterCode.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=RegisterCode-CB980fsG.js.map
