import { b as useRuntimeConfig, l as _sfc_main$1 } from "../server.mjs";
import { defineComponent, mergeProps, unref, createVNode, resolveDynamicComponent, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderClass, ssrRenderAttr, ssrRenderComponent, ssrRenderVNode } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ProductsSlider",
  __ssrInlineRender: true,
  props: {
    products: {},
    disableAction: { type: Boolean }
  },
  setup(__props) {
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CartAction = _sfc_main$1;
      _push(`<swiper-container${ssrRenderAttrs(mergeProps({
        "slides-per-view": "auto",
        class: "py-8"
      }, _attrs), "swiper-container")}><!--[-->`);
      ssrRenderList(_ctx.products, (product, key) => {
        _push(`<swiper-slide class="${ssrRenderClass([{ "border-l": key != _ctx.products.length - 1 }, "w-[150px] flex flex-col items-center px-5"])}"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + product.image)} class="w-full"${ssrRenderAttr("alt", product.title)}>`);
        if (!_ctx.disableAction) {
          _push(ssrRenderComponent(_component_CartAction, {
            product,
            "disable-description": "",
            "hide-cart-link": "",
            class: "mt-5 text-sm"
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        if (_ctx.$variationParamComponent(product.variation["param1_type"]) && product.variation["param2_type"]) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(product.variation["param1_type"])), {
            data: product.variation["param1"],
            class: "text-sm mt-3"
          }, null), _parent);
        } else {
          _push(`<!---->`);
        }
        _push(`</swiper-slide>`);
      });
      _push(`<!--]--></swiper-container>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/checkout/ProductsSlider.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=ProductsSlider-B4X-edAw.js.map
