import { _ as _sfc_main$6, a as _sfc_main$7, b as _sfc_main$a, c as _sfc_main$b, d as _sfc_main$c } from "./View-BN6pemn-.js";
import { defineComponent, computed, resolveComponent, unref, useSSRContext, ref, mergeProps, withCtx, createVNode, toDisplayString, createBlock, createCommentVNode, openBlock, Fragment, renderList, nextTick, watch } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderClass } from "vue/server-renderer";
import { b as useRuntimeConfig, p as productStore, c as useNuxtApp, a as _sfc_main$9, h as _sfc_main$d, u as useState } from "../server.mjs";
import { g as galleryStore } from "./gallery-hwUJSkhT.js";
import { _ as _sfc_main$8 } from "./Dialog-CBk-AHyk.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "#internal/nuxt/paths";
import { defineStore } from "pinia";
import "./MoreText-CtkeWBXn.js";
import "ofetch";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
import "./Component-C6QGchKb.js";
import "./user-utils-B9JSuaai.js";
import "./TextInput-BtVMT3NE.js";
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "GalleryFiles",
  __ssrInlineRender: true,
  setup(__props) {
    const { serverUrl } = useRuntimeConfig().public;
    const galleryState = galleryStore();
    productStore();
    const commentImages = computed(() => {
      return galleryState.files.filter((file) => {
        return file.group == "buyers" && file.path.indexOf(".mp4") == -1;
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(_attrs)}><swiper-container slides-per-view="auto"${ssrRenderAttr("space-between", 10)}><!--[-->`);
      ssrRenderList(unref(commentImages), (file, key) => {
        _push(`<!--[-->`);
        if (key < 5) {
          _push(`<swiper-slide class="w-[70px] h-[70px] lg:w-[80px] lg:h-[80px] cursor-pointer"><img${ssrRenderAttr("src", unref(serverUrl) + "/" + file.path)} class="object-cover h-[70px] lg:h-[80px] rounded-md" alt=""></swiper-slide>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></swiper-container>`);
      if (unref(commentImages).length > 5) {
        _push(`<a class="text-blue-400 mt-3 flex items-center cursor-pointer"><span>نمایش همه</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "angle-left"],
          class: "px-2"
        }, null, _parent));
        _push(`</a>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/GalleryFiles.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const commentStore = defineStore("comment", () => {
  const list = ref({ data: [] });
  const page = ref(0);
  const loading = ref(false);
  const endLoaded = ref(false);
  const fetch = (productId) => {
    if (!loading.value && !endLoaded.value) {
      loading.value = true;
      page.value = page.value + 1;
      useNuxtApp().$axios.get(
        useRuntimeConfig().public.api + "/product/" + productId + "/comments?page=" + page.value
      ).then((response) => {
        if (list.value.data.length == 0) {
          list.value = response.data;
        } else {
          list.value.data = [...list.value.data, ...response.data.data];
        }
        loading.value = false;
        if (response.data.data.length < 10) {
          endLoaded.value = true;
        }
      }).catch(() => {
        loading.value = false;
      });
    }
  };
  const reset = () => {
    page.value = 0;
    endLoaded.value = false;
    list.value = { data: [] };
  };
  return {
    list,
    loading,
    reset,
    fetch
  };
});
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "ProductPage",
  __ssrInlineRender: true,
  setup(__props) {
    const productState = productStore();
    const commentState = commentStore();
    const form = ref(null);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommentStarRating = _sfc_main$6;
      const _component_CommentGalleryFiles = _sfc_main$5;
      const _component_CommentView = _sfc_main$7;
      const _component_CommentCreateDialog = _sfc_main$8;
      _push(`<!--[-->`);
      if (unref(productState).product && unref(commentState).list.data.length > 0) {
        _push(`<div class="flex items-start"><div class="w-[300px]">`);
        if (unref(productState).product.score) {
          _push(`<p><span class="text-2xl font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(unref(productState).product.score))}</span><span> از </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(5))}</span></p>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(productState).product.score) {
          _push(`<div class="flex py-2 items-center">`);
          _push(ssrRenderComponent(_component_CommentStarRating, {
            rating: unref(productState).product.score
          }, null, _parent));
          _push(`<span class="text-xs pr-1"> از مجموع ${ssrInterpolate(_ctx.$replaceEnNumber(unref(productState).product.score_from_sale_count))} امتیاز </span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<p class="text-xs text-gray-500 py-3"> شما هم درباره این کالا دیدگاه ثبت کنید </p><button class="c-btn2 w-full my-2"> ثبت دیدگاه </button></div><div class="w-full flex-grow px-6">`);
        _push(ssrRenderComponent(_component_CommentGalleryFiles, null, null, _parent));
        _push(`<!--[-->`);
        ssrRenderList(unref(commentState).list.data, (row, key) => {
          _push(`<div class="${ssrRenderClass({ "border-b": key != unref(commentState).list.data.length - 1 })}">`);
          _push(ssrRenderComponent(_component_CommentView, { comment: row }, null, _parent));
          _push(`</div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(commentState).list.data && unref(commentState).list.data.length == 0 && !unref(commentState).loading) {
        _push(`<div class="flex flex-col items-center"><p class="pt-4 text-gray-600"> تاکنون برای این محصول نظری ثبت نشده </p><button class="c-btn2 w-auto mt-7 !px-4"> ثبت اولین نظر </button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_CommentCreateDialog, {
        ref_key: "form",
        ref: form,
        product: unref(productState).product
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/desktop/ProductPage.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "OffcanvasView",
  __ssrInlineRender: true,
  props: {
    comment: {}
  },
  setup(__props, { expose: __expose }) {
    const offcanvasRef = ref(null);
    const show = () => {
      offcanvasRef.value.show();
    };
    __expose({
      show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Offcanvas = _sfc_main$9;
      const _component_CommentUserInfo = _sfc_main$b;
      const _component_CommentStarRating = _sfc_main$6;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_CommentLikeDislikeSection = _sfc_main$a;
      _push(ssrRenderComponent(_component_Offcanvas, mergeProps({
        ref_key: "offcanvasRef",
        ref: offcanvasRef,
        direction: "bottom",
        "content-class": "w-full bottom-0 " + (_ctx.comment.text.length > 500 ? "h-full" : "h-auto")
      }, _attrs), {
        header: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-between items-center p-3 border-b"${_scopeId}><div class="flex flex-col"${_scopeId}><div class="flex items-center"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_CommentUserInfo, { comment: _ctx.comment }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_sfc_main$c, {
              time: _ctx.comment.created_at,
              class: "text-gray-400 text-xs mr-1"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (_ctx.comment.buyer == 1) {
              _push2(ssrRenderComponent(_component_CommentStarRating, {
                rating: _ctx.comment.score,
                class: "mt-2"
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
            _push2(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "close"],
              class: "cursor-pointer",
              onClick: ($event) => unref(offcanvasRef).hide()
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-between items-center p-3 border-b" }, [
                createVNode("div", { class: "flex flex-col" }, [
                  createVNode("div", { class: "flex items-center" }, [
                    createVNode(_component_CommentUserInfo, { comment: _ctx.comment }, null, 8, ["comment"]),
                    createVNode(_sfc_main$c, {
                      time: _ctx.comment.created_at,
                      class: "text-gray-400 text-xs mr-1"
                    }, null, 8, ["time"])
                  ]),
                  _ctx.comment.buyer == 1 ? (openBlock(), createBlock(_component_CommentStarRating, {
                    key: 0,
                    rating: _ctx.comment.score,
                    class: "mt-2"
                  }, null, 8, ["rating"])) : createCommentVNode("", true)
                ]),
                createVNode(_component_fa_icon, {
                  icon: ["fas", "close"],
                  class: "cursor-pointer",
                  onClick: ($event) => unref(offcanvasRef).hide()
                }, null, 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="px-3 overflow-auto"${_scopeId}><div class="leading-8 py-2"${_scopeId}>${ssrInterpolate(_ctx.comment.text)}</div><div class="leading-8 py-2"${_scopeId}>${ssrInterpolate(_ctx.comment.text)}</div><div class="flex justify-end items-center pb-2"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_CommentLikeDislikeSection, { comment: _ctx.comment }, null, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "px-3 overflow-auto" }, [
                createVNode("div", { class: "leading-8 py-2" }, toDisplayString(_ctx.comment.text), 1),
                createVNode("div", { class: "leading-8 py-2" }, toDisplayString(_ctx.comment.text), 1),
                createVNode("div", { class: "flex justify-end items-center pb-2" }, [
                  createVNode(_component_CommentLikeDislikeSection, { comment: _ctx.comment }, null, 8, ["comment"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/mobile/OffcanvasView.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "OffcanvasList",
  __ssrInlineRender: true,
  setup(__props, { expose: __expose }) {
    const {
      product
    } = productStore();
    const comment = commentStore();
    const offcanvasRef = ref(null);
    const form = ref(null);
    const show = () => {
      offcanvasRef.value.show();
      nextTick(() => {
        (void 0).querySelector(".comments-list .body").addEventListener("scroll", scroll);
      });
    };
    const selectedMedia = () => {
      offcanvasRef.value.hide();
    };
    const scroll = () => {
      const loadMore = (void 0).querySelector(`.load-more`);
      if (loadMore) {
        const observer = new IntersectionObserver(
          ([entry]) => {
            if (entry.isIntersecting) {
              comment.fetch(product.id);
            }
          },
          { threshold: 0.6 }
        );
        observer.observe(loadMore);
      }
    };
    const showAddCommentForm = () => {
      offcanvasRef.value.hide();
      nextTick(() => {
        form.value.show();
      });
    };
    __expose({
      show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Offcanvas = _sfc_main$9;
      const _component_CommentView = _sfc_main$7;
      const _component_Loading = _sfc_main$d;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_CommentCreateDialog = _sfc_main$8;
      _push(`<!--[--><div class="comments-list">`);
      _push(ssrRenderComponent(_component_Offcanvas, {
        ref_key: "offcanvasRef",
        ref: offcanvasRef,
        direction: "bottom",
        "content-class": "w-full h-full",
        title: _ctx.$replaceEnNumber(unref(comment).list.total) + " دیدگاه"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="p-3"${_scopeId}><!--[-->`);
            ssrRenderList(unref(comment).list.data, (row, key) => {
              _push2(`<div class="${ssrRenderClass({ "border-b": key != unref(comment).list.data.length - 1 })}"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_CommentView, {
                comment: row,
                "selected-media": selectedMedia
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            });
            _push2(`<!--]-->`);
            if (unref(comment).loading) {
              _push2(`<div class="w-full flex justify-center h-20"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Loading, null, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="load-more"${_scopeId}></div></div><div class="c-btn rounded-2xl px-3 py-5 absolute left-5 bottom-7"${_scopeId}><span${_scopeId}>ثبت دیدگاه</span>`);
            _push2(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "comment"],
              class: "pr-2"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "p-3" }, [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(comment).list.data, (row, key) => {
                  return openBlock(), createBlock("div", {
                    key,
                    class: { "border-b": key != unref(comment).list.data.length - 1 }
                  }, [
                    createVNode(_component_CommentView, {
                      comment: row,
                      "selected-media": selectedMedia
                    }, null, 8, ["comment"])
                  ], 2);
                }), 128)),
                unref(comment).loading ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "w-full flex justify-center h-20"
                }, [
                  createVNode(_component_Loading)
                ])) : createCommentVNode("", true),
                createVNode("div", { class: "load-more" })
              ]),
              createVNode("div", {
                class: "c-btn rounded-2xl px-3 py-5 absolute left-5 bottom-7",
                onClick: ($event) => showAddCommentForm()
              }, [
                createVNode("span", null, "ثبت دیدگاه"),
                createVNode(_component_fa_icon, {
                  icon: ["fas", "comment"],
                  class: "pr-2"
                })
              ], 8, ["onClick"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      if (unref(product)) {
        _push(ssrRenderComponent(_component_CommentCreateDialog, {
          ref_key: "form",
          ref: form,
          product: unref(product)
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/mobile/OffcanvasList.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ProductPage",
  __ssrInlineRender: true,
  setup(__props) {
    const detailViewRef = ref(null);
    const totalListRef = ref(null);
    const commentState = commentStore();
    const productState = productStore();
    const selectedComment = ref(null);
    const form = ref(null);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_CommentGalleryFiles = _sfc_main$5;
      const _component_CommentUserInfo = _sfc_main$b;
      const _component_CommentStarRating = _sfc_main$6;
      const _component_TimeAgo = _sfc_main$c;
      const _component_CommentLikeDislikeSection = _sfc_main$a;
      const _component_CommentMobileOffcanvasView = _sfc_main$3;
      const _component_CommentMobileOffcanvasList = _sfc_main$2;
      const _component_CommentCreateDialog = _sfc_main$8;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-4" }, _attrs))}>`);
      if (unref(commentState).list.data.length > 0) {
        _push(`<div class="pb-5 flex justify-between items-center"><div class="tab-title">دیدگاه کاربر ها</div>`);
        if (unref(commentState).list.total && unref(commentState).list.total > 0) {
          _push(`<a class="flex items-center cursor-pointer"><span>مشاهده ${ssrInterpolate(_ctx.$replaceEnNumber(unref(commentState).list.total))} دیدگاه</span>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "angle-left"],
            class: "pr-2"
          }, null, _parent));
          _push(`</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_CommentGalleryFiles, null, null, _parent));
      if (unref(commentState).list.data.length > 0) {
        _push(`<swiper-container space-between="10" slides-per-view="auto" class="mt-3"><!--[-->`);
        ssrRenderList(unref(commentState).list.data, (comment, key) => {
          _push(`<!--[-->`);
          if (key < 5) {
            _push(`<swiper-slide class="w-[260px] border flex flex-col justify-between rounded-md p-3 !h-[270px]"><div>`);
            _push(ssrRenderComponent(_component_CommentUserInfo, { comment }, null, _parent));
            if (comment.buyer == 1) {
              _push(ssrRenderComponent(_component_CommentStarRating, {
                rating: comment.score,
                class: "mt-2"
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="py-2">${ssrInterpolate(comment.text.length < 200 ? comment.text : comment.text.substring(0, 200) + "...")}</div>`);
            if (comment.text.length > 200) {
              _push(`<span class="cursor-pointer text-black font-bold border-b border-b-black"> بیشتر </span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div><div class="flex justify-between">`);
            _push(ssrRenderComponent(_component_TimeAgo, {
              time: comment.created_at,
              class: "text-gray-400 text-xs"
            }, null, _parent));
            _push(ssrRenderComponent(_component_CommentLikeDislikeSection, { comment }, null, _parent));
            _push(`</div></swiper-slide>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></swiper-container>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(selectedComment)) {
        _push(ssrRenderComponent(_component_CommentMobileOffcanvasView, {
          comment: unref(selectedComment),
          ref_key: "detailViewRef",
          ref: detailViewRef
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_CommentMobileOffcanvasList, {
        ref_key: "totalListRef",
        ref: totalListRef
      }, null, _parent));
      _push(ssrRenderComponent(_component_CommentCreateDialog, {
        ref_key: "form",
        ref: form,
        product: unref(productState).product
      }, null, _parent));
      if (unref(commentState).list.data && unref(commentState).list.data.length == 0 && !unref(commentState).loading) {
        _push(`<div class="flex flex-col items-center"><p class="pt-4 text-gray-600"> تاکنون برای این محصول نظری ثبت نشده </p><button class="c-btn2 w-auto mt-7 !px-4"> ثبت اولین نظر </button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/mobile/ProductPage.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ProductPage",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const commentState = commentStore();
    const store = productStore();
    watch(() => store.product, () => {
      if (store.product) {
        commentState.reset();
        commentState.fetch(store.product.id);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommentDesktopProductPage = _sfc_main$4;
      const _component_CommentMobileProductPage = _sfc_main$1;
      _push(`<!--[--><div class="pt-3 lg:py-4"><div class="tab-title">نظرات</div></div>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_CommentDesktopProductPage, null, null, _parent));
      } else {
        _push(ssrRenderComponent(_component_CommentMobileProductPage, null, null, _parent));
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/ProductPage.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=ProductPage-Dv14Jcaz.js.map
