import { defineComponent, ref, resolveComponent, unref, useSSRContext, mergeProps, watch } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import { p as productStore, u as useState } from "../server.mjs";
import { s as specificationsStore } from "./specifications-Vu5A47gN.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "DesktopView",
  __ssrInlineRender: true,
  props: {
    data: {}
  },
  setup(__props) {
    const showAll = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.data) {
        _push(`<div${ssrRenderAttrs(_attrs)}>`);
        if (Object.keys(_ctx.data).length > 0) {
          _push(`<div class="specifications py-8"><div class="header"><p class="text-black font-bold">مشخصات</p></div><div class="body"><!--[-->`);
          ssrRenderList(Object.keys(_ctx.data), (key, index) => {
            _push(`<div class="flex items-center">`);
            if (unref(showAll) || !unref(showAll) && index < 7) {
              _push(`<!--[--><p class="specification-name">${ssrInterpolate(_ctx.data[key].key)}</p><div class="w-full specification-value"><!--[-->`);
              ssrRenderList(_ctx.data[key].values, (value, key2) => {
                _push(`<p>${ssrInterpolate(value)}</p>`);
              });
              _push(`<!--]--></div><!--]-->`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]--></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (Object.keys(_ctx.data).length > 7) {
          _push(`<div class="text-blue-500 flex items-center cursor-pointer text-sm py-5">`);
          if (!unref(showAll)) {
            _push(`<span>مشاهده بیشتر</span>`);
          } else {
            _push(`<span>مشاهده کمتر</span>`);
          }
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "fa-angle-left"],
            class: "px-1.5"
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/DesktopView.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "MobileView",
  __ssrInlineRender: true,
  props: {
    data: {}
  },
  setup(__props) {
    const store = productStore();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.data) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "pt-3 pb-6" }, _attrs))}><p class="font-bold">جدول مشخصات</p><table class="w-full mt-3 !text-[13px]"><!--[-->`);
        ssrRenderList(Object.keys(_ctx.data), (key, index) => {
          _push(`<!--[-->`);
          if (index < 5 || unref(store).descriptionOffcanvas == "show") {
            _push(`<tr><th class="bg-gray-100 w-[100px] border-b text-center py-2 !font-normal">${ssrInterpolate(_ctx.data[key].key)}</th><td class="border-b p-2"><!--[-->`);
            ssrRenderList(_ctx.data[key].values, (value, key2) => {
              _push(`<span>${ssrInterpolate(value)}</span>`);
            });
            _push(`<!--]--></td></tr>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></table>`);
        if (Object.keys(_ctx.data).length > 5 && unref(store).descriptionOffcanvas == "hide") {
          _push(`<div class="flex justify-center mt-4"><button class="btn bg-gray-100 w-auto text-sm"> مشاهده ادامه مشخصات `);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "angle-left"],
            class: "pr-2"
          }, null, _parent));
          _push(`</button></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/MobileView.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Product",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const theme = useState("theme");
    const store = specificationsStore();
    watch(() => props.product, () => {
      if (props.product) {
        store.getData(props.product.id);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_SpecificationsDesktopView = _sfc_main$2;
      const _component_SpecificationsMobileView = _sfc_main$1;
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_SpecificationsDesktopView, mergeProps({
          data: unref(store).data
        }, _attrs), null, _parent));
      } else {
        _push(ssrRenderComponent(_component_SpecificationsMobileView, mergeProps({
          data: unref(store).data
        }, _attrs), null, _parent));
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/specifications/Product.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=Product-C6hi_VV_.js.map
