import { u as useState, g as __nuxt_component_0, c as useNuxtApp, e as useRoute } from "../server.mjs";
import { defineComponent, resolveComponent, mergeProps, unref, withCtx, createVNode, useSSRContext, ref, resolveDynamicComponent, createBlock, createCommentVNode, toDisplayString, openBlock } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderVNode, ssrRenderSlot } from "vue/server-renderer";
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Info",
  __ssrInlineRender: true,
  setup(__props) {
    const user = useState("user");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex justify-between items-center p-3" }, _attrs))}><div class="flex flex-col">`);
      if (unref(user).name) {
        _push(`<span class="font-bold">${ssrInterpolate(unref(user).name)}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<span class="text-sm text-gray-400 py-1.5">${ssrInterpolate(_ctx.$replaceEnNumber(unref(user).username))}</span></div>`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: "/profile/personal-info",
        class: "text-blue-500"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "edit"] }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_fa_icon, { icon: ["fas", "edit"] })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/users/panel/Info.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Menus",
  __ssrInlineRender: true,
  setup(__props) {
    const menus = ref([]);
    const global = useNuxtApp().vueApp.config.globalProperties;
    const route = useRoute();
    const theme = useState("theme");
    useState("logout-request");
    const components = global["$user-panel:before-menus"];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(components)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(components), (component) => {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component), null, null), _parent);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`<ul class="user-panel-menus"><!--[-->`);
      ssrRenderList(unref(menus), (menu) => {
        _push(`<li>`);
        if (unref(route).path == menu.route) {
          _push(`<div class="active"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: menu.route
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div${_scopeId}>`);
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: menu.icon
              }, null, _parent2, _scopeId));
              _push2(`<span${_scopeId}>${ssrInterpolate(menu.title)}</span></div>`);
              if (unref(theme) == "mobile") {
                _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "fa-angle-left"] }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("div", null, [
                  createVNode(_component_fa_icon, {
                    icon: menu.icon
                  }, null, 8, ["icon"]),
                  createVNode("span", null, toDisplayString(menu.title), 1)
                ]),
                unref(theme) == "mobile" ? (openBlock(), createBlock(_component_fa_icon, {
                  key: 0,
                  icon: ["fas", "fa-angle-left"]
                })) : createCommentVNode("", true)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--><li class="cursor-pointer !border-0">`);
      _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "arrow-right-from-bracket"] }, null, _parent));
      _push(`<span> خروج از حساب کاربری </span></li></ul></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/users/panel/Menus.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Layout",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_UsersPanelInfo = _sfc_main$2;
      const _component_UsersPanelMenus = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "user-layout flex items-start" }, _attrs))}>`);
      if (unref(theme) == "desktop") {
        _push(`<div class="sidebar">`);
        _push(ssrRenderComponent(_component_UsersPanelInfo, null, null, _parent));
        _push(ssrRenderComponent(_component_UsersPanelMenus, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-full flex-grow lg:pr-4">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/users/Layout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _,
  _sfc_main$2 as a,
  _sfc_main$1 as b
};
//# sourceMappingURL=Layout-tZUvOK2Y.js.map
